/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import org.eclipse.persistence.jpa.rs.PersistenceContext;

public final class HrefHelper {
    public static final String BASE_REST_SCHEMAS_URL = "rest-schemas/";

    public static StringBuilder getRoot(String baseUri, String version, String context) {
        StringBuilder href = new StringBuilder(baseUri);
        href.append(version).append("/").append(context);
        return href;
    }

    public static StringBuilder getRoot(PersistenceContext context) {
        StringBuilder href = new StringBuilder(context.getBaseURI().toString());
        href.append(context.getVersion()).append("/").append(context.getName());
        return href;
    }

    public static StringBuilder getMetadataRoot(PersistenceContext context) {
        return HrefHelper.getRoot(context).append("/metadata-catalog");
    }

    public static StringBuilder getEntityRoot(PersistenceContext context, String entityName) {
        return HrefHelper.getRoot(context).append("/entity/").append(entityName);
    }

    public static StringBuilder getQueryRoot(PersistenceContext context, String queryName) {
        return HrefHelper.getRoot(context).append("/query/").append(queryName);
    }

    public static String buildBaseRestSchemaRef(String type2) {
        return BASE_REST_SCHEMAS_URL + type2;
    }

    public static String buildEntityHref(PersistenceContext context, String entityName, String entityId) {
        return HrefHelper.getEntityRoot(context, entityName).append("/").append(entityId).toString();
    }

    public static String buildEntityFieldHref(PersistenceContext context, String entityName, String entityId, String fieldName) {
        return HrefHelper.getEntityRoot(context, entityName).append("/").append(entityId).append("/").append(fieldName).toString();
    }

    public static String buildEntityMetadataHref(PersistenceContext context, String entityName) {
        return HrefHelper.getMetadataRoot(context).append("/entity/").append(entityName).toString();
    }

    public static String buildEntityDescribesHref(PersistenceContext context, String entityName) {
        return HrefHelper.getEntityRoot(context, entityName).toString();
    }

    public static String buildQueryDescribesHref(PersistenceContext context, String queryName) {
        return HrefHelper.getQueryRoot(context, queryName).toString();
    }

    public static String buildMetadataCatalogHref(PersistenceContext context) {
        return HrefHelper.getMetadataRoot(context).toString();
    }

    public static String buildQueryHref(PersistenceContext context, String queryName, String queryParams) {
        return HrefHelper.getQueryRoot(context, queryName).append(queryParams).toString();
    }

    public static String buildQueryMetadataHref(PersistenceContext context, String queryName) {
        return HrefHelper.getMetadataRoot(context).append("/query/").append(queryName).toString();
    }
}

