/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.jvnet.hk2.config.Dom;

@Provider
@Produces(value={"application/json"})
public class GetResultListJsonProvider
extends BaseProvider<GetResultList> {
    public GetResultListJsonProvider() {
        super(GetResultList.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(GetResultList proxy) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("entity", new JSONObject());
            obj.put("methods", ProviderUtil.getJsonForMethodMetaData(proxy.getMetaData()));
            if (proxy.getDomList().size() > 0) {
                obj.put("childResources", this.getResourcesLinks(proxy.getDomList()));
            }
            if (proxy.getCommandResourcesPaths().length > 0) {
                obj.put("commands", this.getCommandLinks(proxy.getCommandResourcesPaths()));
            }
        }
        catch (JSONException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return obj.toString();
    }

    private JSONArray getResourcesLinks(List<Dom> proxyList) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, String> link : this.getResourceLinks(proxyList).entrySet()) {
            array.put(link.getValue());
        }
        return array;
    }

    private JSONArray getCommandLinks(String[][] commandResourcesPaths) throws JSONException {
        JSONArray array = new JSONArray();
        for (String[] commandResourcePath : commandResourcesPaths) {
            array.put(ProviderUtil.getElementLink((UriInfo)this.uriInfo.get(), commandResourcePath[0]));
        }
        return array;
    }
}

