/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(mode=0, value=10)
public final class ConfigConfigBeanListener
implements ConfigListener {
    @Inject
    private ServiceLocator habitat;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    static final Logger logger = ConfigApiLoggerInfo.getLogger();

    @Override
    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent e : events) {
            Object nv;
            if (e.getSource().getClass() != this.config.getClass()) continue;
            Object ov = e.getOldValue();
            if (ov instanceof ConfigBeanProxy) {
                ConfigBeanProxy ovbp = (ConfigBeanProxy)ov;
                logger.log(Level.FINE, "NCLS-CFGAPI-00020", ConfigSupport.getImpl(ovbp).getProxyType().getName());
                ServiceLocatorUtilities.removeFilter(this.habitat, BuilderHelper.createNameAndContractFilter(ConfigSupport.getImpl(ovbp).getProxyType().getName(), "default-instance-name"));
            }
            if (!((nv = e.getNewValue()) instanceof ConfigBean)) continue;
            ConfigBean nvb = (ConfigBean)nv;
            Object nvbp = nvb.getProxy(nvb.getProxyType());
            logger.log(Level.FINE, "NCLS-CFGAPI-00021", nvb.getProxyType().getName());
            ServiceLocatorUtilities.addOneConstant(this.habitat, nvbp, "default-instance-name", nvb.getProxyType());
        }
        return null;
    }
}

