/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support.datatypes;

import org.glassfish.config.support.datatypes.NonNegativeInteger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.ValidationException;

@Service
public class PositiveInteger
implements DataType {
    @Override
    public void validate(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("null value is not of type PositiveInteger");
        }
        if (NonNegativeInteger.isTokenized(value)) {
            return;
        }
        try {
            long number = Long.parseLong(value);
            if (number < 1L || number > Integer.MAX_VALUE) {
                String msg = "value: " + number + " not applicable for PositiveInteger [1, " + Integer.MAX_VALUE + "] data type";
                throw new ValidationException(msg);
            }
        }
        catch (NumberFormatException e) {
            String msg = "value: " + value + " does not represent an Integer";
            throw new ValidationException(msg);
        }
    }
}

