/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.ProbeInfo;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeHandle;
import org.glassfish.flashlight.client.StatefulProbeClientInvoker;

public class FlashlightProbe
implements ProbeHandle,
ProbeInfo {
    private Method probeMethod;
    public static final String SELF = "@SELF";
    private int id;
    private Class providerClazz;
    private String moduleProviderName;
    private String moduleName;
    private String probeName;
    private String probeProviderName;
    private String[] probeParamNames;
    private Class[] paramTypes;
    private volatile List<ProbeClientInvoker> invokerList = new ArrayList<ProbeClientInvoker>(2);
    private String providerJavaMethodName;
    private AtomicBoolean listenerEnabled = new AtomicBoolean(false);
    private String probeDesc;
    private Object dtraceProviderImpl;
    private Method dtraceMethod;
    private boolean hasSelf;
    private boolean hidden;
    private boolean firstTransform = true;
    private ConcurrentMap<Integer, ProbeClientInvoker> invokers = new ConcurrentHashMap<Integer, ProbeClientInvoker>();
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightProbe.class);
    private FlashlightProbe parent = null;
    private boolean stateful = false;
    private boolean statefulReturn = false;
    private boolean statefulException = false;
    private String[] profileNames = null;

    public FlashlightProbe(int id, Class providerClazz, String moduleProviderName, String moduleName, String probeProviderName, String probeName, String[] probeParamNames, Class[] paramTypes, boolean self, boolean hidden, boolean stateful, boolean statefulReturn, boolean statefulException, String[] profileNames) {
        this.id = id;
        this.providerClazz = providerClazz;
        this.moduleProviderName = moduleProviderName;
        this.moduleName = moduleName;
        this.probeProviderName = probeProviderName;
        this.probeName = probeName;
        this.probeDesc = moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
        this.hasSelf = self;
        this.hidden = hidden;
        this.stateful = stateful;
        this.statefulReturn = statefulReturn;
        this.statefulException = statefulException;
        this.profileNames = profileNames;
        if (self) {
            if (this.isMethodStatic()) {
                String errStr = localStrings.getLocalString("cannotDefineSelfOnStatic", "Cannot define \"self\" on a static method - ", this.probeDesc);
                throw new RuntimeException(errStr);
            }
            this.probeParamNames = new String[probeParamNames.length + 1];
            this.paramTypes = new Class[paramTypes.length + 1];
            this.probeParamNames[0] = SELF;
            this.paramTypes[0] = providerClazz;
            for (int index = 0; index < probeParamNames.length; ++index) {
                this.probeParamNames[index + 1] = probeParamNames[index];
                this.paramTypes[index + 1] = paramTypes[index];
            }
        } else {
            this.probeParamNames = probeParamNames;
            this.paramTypes = paramTypes;
        }
    }

    public Method getProbeMethod() {
        return this.probeMethod;
    }

    public void setProbeMethod(Method probeMethod) {
        this.probeMethod = probeMethod;
    }

    private boolean isMethodStatic() {
        try {
            int modifier = this.getProviderClazz().getDeclaredMethod(this.getProviderJavaMethodName(), this.getParamTypes()).getModifiers();
            return Modifier.isStatic(modifier);
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean addInvoker(ProbeClientInvoker invoker) {
        boolean isFirst;
        boolean bl = isFirst = this.invokers.isEmpty() && this.firstTransform;
        if (this.invokers.putIfAbsent(invoker.getId(), invoker) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding an invoker that already exists: " + invoker.getId() + "  &&&&&&&&&&");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding an Invoker that does not exist: " + invoker.getId() + " $$$$$$$$$$$$$");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total invokers = " + this.invokers.size());
        }
        this.listenerEnabled.set(true);
        this.firstTransform = false;
        this.initInvokerList();
        return isFirst;
    }

    public synchronized boolean removeInvoker(ProbeClientInvoker invoker) {
        ProbeClientInvoker pci = (ProbeClientInvoker)this.invokers.remove(invoker.getId());
        if (pci != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing an invoker that already exists: " + pci.getId() + "  ##########");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Failed to remove an invoker that does not exist: " + invoker.getId() + "  %%%%%%%%%");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total invokers = " + this.invokers.size());
        }
        this.listenerEnabled.set(!this.invokers.isEmpty());
        this.initInvokerList();
        return this.listenerEnabled.get();
    }

    public void fireProbe(Object[] params) {
        if (!this.listenerEnabled.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.fireProbe(params);
        }
        int sz = this.invokerList.size();
        for (int i = 0; i < sz; ++i) {
            ProbeClientInvoker invoker = this.invokerList.get(i);
            if (invoker == null) continue;
            invoker.invoke(params);
        }
    }

    public ArrayList<ProbeInvokeState> fireProbeBefore(Object[] params) {
        if (!this.listenerEnabled.get()) {
            return null;
        }
        ArrayList<ProbeInvokeState> probeInvokeStates = new ArrayList<ProbeInvokeState>();
        if (this.parent != null) {
            ArrayList<ProbeInvokeState> parentStates = this.parent.fireProbeBefore(params);
            probeInvokeStates.addAll(parentStates);
        }
        int sz = this.invokerList.size();
        for (int i = 0; i < sz; ++i) {
            StatefulProbeClientInvoker invoker = (StatefulProbeClientInvoker)this.invokerList.get(i);
            if (invoker == null) continue;
            probeInvokeStates.add(new ProbeInvokeState(invoker.getId(), invoker.invokeBefore(params)));
        }
        return probeInvokeStates;
    }

    public void fireProbeAfter(Object returnValue, ArrayList<ProbeInvokeState> states) {
        if (!this.listenerEnabled.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.fireProbeAfter(returnValue, states);
        }
        int sz = this.invokerList.size();
        int stateIndex = -1;
        for (int i = 0; i < sz; ++i) {
            StatefulProbeClientInvoker invoker = (StatefulProbeClientInvoker)this.invokerList.get(i);
            if (invoker == null || (stateIndex = this.findStateIndex(invoker.getId(), states)) < 0) continue;
            invoker.invokeAfter(states.get(stateIndex).getState(), returnValue);
        }
    }

    public void fireProbeOnException(Object exceptionValue, ArrayList<ProbeInvokeState> states) {
        if (!this.listenerEnabled.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.fireProbeOnException(exceptionValue, states);
        }
        int sz = this.invokerList.size();
        int stateIndex = -1;
        for (int i = 0; i < sz; ++i) {
            StatefulProbeClientInvoker invoker = (StatefulProbeClientInvoker)this.invokerList.get(i);
            if (invoker == null || (stateIndex = this.findStateIndex(invoker.getId(), states)) < 0) continue;
            invoker.invokeOnException(states.get(stateIndex).getState(), exceptionValue);
        }
    }

    public boolean isEnabled() {
        return this.listenerEnabled.get();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getModuleProviderName() {
        return this.moduleProviderName;
    }

    @Override
    public String getModuleName() {
        return this.moduleProviderName;
    }

    @Override
    public String getProbeProviderName() {
        return this.probeProviderName;
    }

    @Override
    public String getProbeName() {
        return this.probeName;
    }

    @Override
    public String[] getProbeParamNames() {
        return this.probeParamNames;
    }

    @Override
    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public String getProviderJavaMethodName() {
        return this.providerJavaMethodName;
    }

    public void setProviderJavaMethodName(String providerJavaMethodName) {
        this.providerJavaMethodName = providerJavaMethodName;
    }

    public String getProbeDesc() {
        return this.probeDesc;
    }

    public static String getProbeDesc(String moduleProviderName, String moduleName, String probeProviderName, String probeName) {
        return moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
    }

    public Class getProviderClazz() {
        return this.providerClazz;
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder(this.moduleProviderName + ":" + this.moduleName + ":" + this.probeProviderName + ":" + this.probeName);
        String delim = " (";
        for (int i = 0; i < this.paramTypes.length; ++i) {
            sbldr.append(delim).append(this.paramTypes[i] == null ? " " : this.paramTypes[i].getName());
            sbldr.append(" ").append(this.probeParamNames[i] == null ? " " : this.probeParamNames[i]);
            delim = ", ";
        }
        if (this.paramTypes.length == 0) {
            sbldr.append(" (");
        }
        sbldr.append(")");
        return sbldr.toString();
    }

    public void setDTraceProviderImpl(Object impl) {
        this.dtraceProviderImpl = impl;
    }

    public Object getDTraceProviderImpl() {
        return this.dtraceProviderImpl;
    }

    @Override
    public Method getDTraceMethod() {
        return this.dtraceMethod;
    }

    public void setDTraceMethod(Method m) {
        this.dtraceMethod = m;
    }

    public boolean hasSelf() {
        return this.hasSelf;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setParent(FlashlightProbe parent) {
        if (this.stateful != parent.getStateful()) {
            return;
        }
        this.parent = parent;
    }

    public boolean getStateful() {
        return this.stateful;
    }

    public boolean getStatefulReturn() {
        return this.statefulReturn;
    }

    public boolean getStatefulException() {
        return this.statefulException;
    }

    public String[] getProfileNames() {
        return this.profileNames;
    }

    private void initInvokerList() {
        Set entries = this.invokers.entrySet();
        ArrayList<ProbeClientInvoker> invList = new ArrayList<ProbeClientInvoker>(2);
        if (this.stateful) {
            for (Map.Entry entry : entries) {
                ProbeClientInvoker invoker = (ProbeClientInvoker)entry.getValue();
                if (!(invoker instanceof StatefulProbeClientInvoker)) continue;
                invList.add(invoker);
            }
        } else {
            for (Map.Entry entry : entries) {
                ProbeClientInvoker invoker = (ProbeClientInvoker)entry.getValue();
                invList.add(invoker);
            }
        }
        this.invokerList = invList;
    }

    private int findStateIndex(int invokerId, ArrayList<ProbeInvokeState> states) {
        if (states == null) {
            return -1;
        }
        int size = states.size();
        ProbeInvokeState state = null;
        for (int stateIndex = 0; stateIndex < size; ++stateIndex) {
            state = states.get(stateIndex);
            if (invokerId != state.getInvokerId()) continue;
            return stateIndex;
        }
        return -1;
    }

    public static final class ProbeInvokeState {
        private int invokerId;
        private Object state = null;

        ProbeInvokeState() {
        }

        ProbeInvokeState(int invokerId, Object state) {
            this.invokerId = invokerId;
            this.state = state;
        }

        final Object getState() {
            return this.state;
        }

        final int getInvokerId() {
            return this.invokerId;
        }
    }
}

