/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.util.i18n.StringManager;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public final class HealthHistory
implements ConfigListener {
    private static final StringManager strings = StringManager.getManager(HealthHistory.class);
    @LoggerInfo(subsystem="CLSTR", description="Group Management Service Logger", publish=true)
    private static final String GMSBS_LOGGER_NAME = "javax.enterprise.cluster.gms.bootstrap";
    @LogMessagesResourceBundle
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.bootstrap.LogMessages";
    static final Logger GMSBS_LOGGER = Logger.getLogger("javax.enterprise.cluster.gms.bootstrap", "org.glassfish.cluster.gms.bootstrap.LogMessages");
    @LogMessageInfo(message="Adding instance {0} to health history table.", level="INFO")
    private static final String GMS_ADDING_INSTANCE = "NCLS-CLSTR-20001";
    @LogMessageInfo(message="Instance {0} was not in map when deleted from health history table.", level="WARNING", cause="More than one call may have been made to remove this instance from the cluster. This has no other effect on the health history information.", action="No action is necessary.")
    private static final String GMS_INSTANCE_NOT_PRESENT = "NCLS-CLSTR-20002";
    @LogMessageInfo(message="Deleting instance {0} from health history table.", level="INFO")
    private static final String GMS_DELETE_INSTANCE = "NCLS-CLSTR-20003";
    @LogMessageInfo(message="Duplicate instance {0} ignored in health history.", level="WARNING", cause="There may be more than one instance in the cluster with the same name.", action="Check that instance names are unique within the cluster.")
    private static final String GMS_DUPLICATE_INSTANCE = "NCLS-CLSTR-20004";
    @LogMessageInfo(message="State already known for instance {0}. Not adding to health history table.", level="INFO")
    private static final String GMS_INSTANCE_ALREADY_PRESENT = "NCLS-CLSTR-20005";
    @LogMessageInfo(message="New state {0} added for unknown instance {1}", level="INFO")
    private static final String GMS_INSTANCE_UNKNOWN_STATE = "NCLS-CLSTR-20006";
    public static final long NOTIME = -1L;
    private final ConcurrentMap<String, InstanceHealth> healthMap;

    public HealthHistory(Cluster cluster) {
        this.healthMap = new ConcurrentHashMap<String, InstanceHealth>(cluster.getInstances().size());
        for (Server server : cluster.getInstances()) {
            if (server.isDas()) continue;
            if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMSBS_LOGGER.log(LogLevel.FINE, String.format("instance name in HealthHistory constructor %s", server.getName()));
            }
            if (this.healthMap.putIfAbsent(server.getName(), new InstanceHealth(STATE.NOT_RUNNING, -1L)) == null) continue;
            GMSBS_LOGGER.log(LogLevel.WARNING, GMS_DUPLICATE_INSTANCE, server.getName());
        }
    }

    public InstanceHealth getHealthByInstance(String name) {
        return (InstanceHealth)this.healthMap.get(name);
    }

    public List<String> getInstancesByState(STATE targetState) {
        ArrayList<String> retVal = new ArrayList<String>(this.healthMap.size());
        for (String name : this.healthMap.keySet()) {
            if (((InstanceHealth)this.healthMap.get((Object)name)).state != targetState) continue;
            retVal.add(name);
        }
        return retVal;
    }

    public Set<String> getInstances() {
        return Collections.unmodifiableSet(this.healthMap.keySet());
    }

    public void updateHealth(Signal signal) {
        if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
            GMSBS_LOGGER.log(LogLevel.FINE, "signal: " + signal.toString());
        }
        String name = signal.getMemberToken();
        long time = signal.getStartTime();
        STATE state = null;
        if (signal instanceof JoinNotificationSignal) {
            state = STATE.RUNNING;
        } else if (signal instanceof JoinedAndReadyNotificationSignal) {
            JoinedAndReadyNotificationSignal jar = (JoinedAndReadyNotificationSignal)signal;
            RejoinSubevent sub = jar.getRejoinSubevent();
            if (sub == null) {
                if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
                    GMSBS_LOGGER.log(LogLevel.FINE, "it's a joined and ready");
                }
                state = STATE.RUNNING;
            } else {
                if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
                    GMSBS_LOGGER.log(LogLevel.FINE, "it's a rejoin");
                }
                state = STATE.REJOINED;
                time = sub.getGroupJoinTime();
            }
        } else if (signal instanceof FailureNotificationSignal) {
            state = STATE.FAILURE;
            time = System.currentTimeMillis();
        } else if (signal instanceof PlannedShutdownSignal) {
            state = STATE.SHUTDOWN;
            time = System.currentTimeMillis();
        } else {
            if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMSBS_LOGGER.log(LogLevel.FINE, String.format("Signal %s not handled in updateHealth", signal.toString()));
            }
            return;
        }
        InstanceHealth ih = new InstanceHealth(state, time);
        if (GMSBS_LOGGER.isLoggable(LogLevel.FINE)) {
            GMSBS_LOGGER.log(LogLevel.FINE, String.format("updating health with %s : %s for signal %s", name, ih.toString(), signal.toString()));
        }
        if (this.healthMap.put(name, ih) == null) {
            GMSBS_LOGGER.log(LogLevel.INFO, GMS_INSTANCE_UNKNOWN_STATE, new Object[]{state, name});
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            ServerRef instance;
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (oldVal instanceof ServerRef && newVal == null) {
                instance = (ServerRef)oldVal;
                this.deleteInstance(instance.getRef());
                continue;
            }
            if (!(newVal instanceof ServerRef) || oldVal != null) continue;
            instance = (ServerRef)newVal;
            this.addInstance(instance.getRef());
        }
        return null;
    }

    private void deleteInstance(String name) {
        GMSBS_LOGGER.log(LogLevel.INFO, GMS_DELETE_INSTANCE, name);
        InstanceHealth oldHealth = (InstanceHealth)this.healthMap.remove(name);
        if (oldHealth == null) {
            GMSBS_LOGGER.log(LogLevel.WARNING, GMS_INSTANCE_NOT_PRESENT, name);
        }
    }

    private void addInstance(String name) {
        GMSBS_LOGGER.log(LogLevel.INFO, GMS_ADDING_INSTANCE, name);
        InstanceHealth oldHealth = this.healthMap.putIfAbsent(name, new InstanceHealth(STATE.NOT_RUNNING, -1L));
        if (oldHealth != null) {
            GMSBS_LOGGER.log(LogLevel.INFO, GMS_INSTANCE_ALREADY_PRESENT, name);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return strings;
    }

    public static final class InstanceHealth {
        public final STATE state;
        public final long time;

        InstanceHealth(STATE state, long time) {
            this.state = state;
            this.time = time;
        }

        public String toString() {
            return String.format("InstanceHealth: state '%s' time '%s'", new Object[]{this.state, new Date(this.time).toString()});
        }
    }

    public static enum STATE {
        NOT_RUNNING(HealthHistory.access$000().getString("state.not_running")),
        RUNNING(HealthHistory.access$000().getString("state.running")),
        REJOINED(HealthHistory.access$000().getString("state.rejoined")),
        FAILURE(HealthHistory.access$000().getString("state.failure")),
        SHUTDOWN(HealthHistory.access$000().getString("state.shutdown"));

        private final String stringVal;

        private STATE(String stringVal) {
            this.stringVal = stringVal;
        }

        public String toString() {
            return this.stringVal;
        }
    }
}

