/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.Extension;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.glassfish.grizzly.websockets.WebSocketListener;

public abstract class WebSocketApplication
extends WebSocketAdapter {
    private final ConcurrentMap<WebSocket, Boolean> sockets = DataStructures.getConcurrentMap();
    private final List<Extension> supportedExtensions = new ArrayList<Extension>(2);
    private final List<String> supportedProtocols = new ArrayList<String>(2);

    @Deprecated
    public WebSocket createSocket(ProtocolHandler handler, WebSocketListener ... listeners) {
        return this.createSocket(handler, (HttpRequestPacket)null, listeners);
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        return new DefaultWebSocket(handler, requestPacket, listeners);
    }

    @Override
    public void onClose(WebSocket socket, DataFrame frame) {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    public void onExtensionNegotiation(List<Extension> extensions) {
    }

    public final boolean upgrade(HttpRequestPacket request) {
        return "WebSocket".equalsIgnoreCase(request.getHeader(Header.Upgrade)) && this.isApplicationRequest(request);
    }

    public boolean isApplicationRequest(HttpRequestPacket request) {
        return false;
    }

    public List<Extension> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return this.supportedProtocols;
    }

    protected Set<WebSocket> getWebSockets() {
        return this.sockets.keySet();
    }

    protected boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    public boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }

    protected void handshake(HandShake handshake) throws HandshakeException {
    }

    protected boolean onError(WebSocket webSocket, Throwable t) {
        return true;
    }
}

