/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-database-vendor-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-database-vendor-names", description="Get Database Vendor Names")})
public class GetDatabaseVendorNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Set<String> vendorNames = this.connectorRuntime.getDatabaseVendorNames();
            Properties extraProperties = new Properties();
            extraProperties.put("vendorNames", new ArrayList<String>(vendorNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-database-vendor-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

