/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class JdbcDataSource
implements DataSource {
    private ResourceInfo resourceInfo;
    private PrintWriter logWriter;
    private int loginTimeout;

    public void setResourceInfo(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        this.validateResource(resourceInfo);
        this.resourceInfo = resourceInfo;
    }

    private void validateResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        String tmpJndiName;
        ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
        String jndiName = resourceInfo.getName();
        String suffix = ConnectorsUtil.getValidSuffix(jndiName);
        if (suffix != null && resourcesUtil.getResource(tmpJndiName = jndiName.substring(0, jndiName.lastIndexOf(suffix)), resourceInfo.getApplicationName(), resourceInfo.getModuleName(), JdbcResource.class) != null) {
            return;
        }
        if (resourcesUtil.getResource(resourceInfo, JdbcResource.class) == null) {
            throw new ConnectorRuntimeException("Invalid resource : " + resourceInfo);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo, username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not supported operation");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported operation");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported operation");
    }
}

