/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.servlet.internal;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2InjectedTarget;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2LocatorManager;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionTargetListener;
import org.glassfish.jersey.internal.util.collection.DataStructures;

public class ServletHk2LocatorManager
implements Hk2LocatorManager,
InjectionTargetListener {
    private final ConcurrentMap<String, ServiceLocator> locatorsByContextPath = DataStructures.createConcurrentMap();
    private final ConcurrentMap<ClassLoader, List<Hk2InjectedTarget>> injectionTargetsByAppClassLoader = DataStructures.createConcurrentMap();
    private volatile BeanManager beanManager;
    private volatile ServiceLocator locator;
    private volatile ServletContext servletContext;
    private volatile boolean multipleLocators = false;

    @Override
    public void registerLocator(ServiceLocator locator) {
        if (this.locator == null) {
            this.locator = locator;
        } else {
            this.multipleLocators = true;
            this.servletContext = CdiUtil.getBeanReference(ServletContext.class, this.getBeanManager());
        }
        ServletConfig hk2ServletConfig = locator.getService(ServletConfig.class, new Annotation[0]);
        ServletContext hk2ServletContext = hk2ServletConfig != null ? hk2ServletConfig.getServletContext() : locator.getService(ServletContext.class, new Annotation[0]);
        this.locatorsByContextPath.put(hk2ServletContext.getContextPath(), locator);
        ClassLoader webappClassLoader = hk2ServletContext.getClassLoader();
        List targets = (List)this.injectionTargetsByAppClassLoader.get(webappClassLoader);
        if (targets != null) {
            for (Hk2InjectedTarget target : targets) {
                target.setLocator(locator);
            }
        }
    }

    private BeanManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = CdiUtil.getBeanManager();
        }
        return this.beanManager;
    }

    @Override
    public ServiceLocator getEffectiveLocator() {
        return this.locator == null ? null : (!this.multipleLocators ? this.locator : (ServiceLocator)this.locatorsByContextPath.get(this.servletContext.getContextPath()));
    }

    @Override
    public void notify(Hk2InjectedTarget target) {
        LinkedList<Hk2InjectedTarget> newList = new LinkedList<Hk2InjectedTarget>();
        LinkedList<Hk2InjectedTarget> existingList = this.injectionTargetsByAppClassLoader.putIfAbsent(target.getInjectionTargetClassLoader(), newList);
        (existingList != null ? existingList : newList).add(target);
    }
}

