/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.CreateHTTPLBRefCommand;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.glassfish.loadbalancer.config.LoadBalancer;
import org.glassfish.loadbalancer.config.LoadBalancers;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-lb-ref")
@PerLookup
@I18n(value="delete.http.lb.ref")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=LbConfig.class, opType=RestEndpoint.OpType.POST, path="delete-http-lb-ref", description="delete-http-lb-ref")})
public final class DeleteHTTPLBRefCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=true)
    String config;
    @Param(optional=true)
    String lbname;
    @Param(optional=true, defaultValue="false")
    String force;
    @Param(primary=true)
    String target;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPLBRefCommand.class);

    @Override
    public void execute(AdminCommandContext context) {
        String msg;
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        boolean isCluster = this.tgt.isCluster(this.target);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("[LB-ADMIN] deleteLBRef called for target " + this.target);
        }
        if (this.config != null && this.lbname != null) {
            String msg2 = localStrings.getLocalString("EitherConfigOrLBName", "Either LB name or LB config name, not both");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg2);
            return;
        }
        if (this.config == null && this.lbname == null) {
            String msg3 = localStrings.getLocalString("SpecifyConfigOrLBName", "Please specify either LB name or LB config name.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg3);
            return;
        }
        LbConfigs lbconfigs = this.domain.getExtensionByType(LbConfigs.class);
        if (lbconfigs == null) {
            String msg4 = localStrings.getLocalString("NoLbConfigsElement", "Empty lb-configs");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg4);
            return;
        }
        if (this.config != null) {
            if (lbconfigs.getLbConfig(this.config) == null) {
                String msg5 = localStrings.getLocalString("LbConfigDoesNotExist", "Specified LB config {0} does not exist", this.config);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg5);
                return;
            }
        } else if (this.lbname != null) {
            LoadBalancers lbs = this.domain.getExtensionByType(LoadBalancers.class);
            if (lbs == null) {
                String msg6 = localStrings.getLocalString("NoLoadBalancersElement", "No Load balancers defined.");
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg6);
                return;
            }
            LoadBalancer lb = lbs.getLoadBalancer(this.lbname);
            if (lb == null) {
                String msg7 = localStrings.getLocalString("LoadBalancerNotDefined", "Load balancer [{0}] not found.", this.lbname);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg7);
                return;
            }
            this.config = lb.getLbConfigName();
        }
        if (isCluster) {
            this.deleteClusterFromLBConfig(lbconfigs, this.config, this.target);
            msg = localStrings.getLocalString("http_lb_admin.DeleteClusterFromConfig", "Deleted cluster {0} from Lb", this.target, this.config);
            this.logger.info(msg);
        } else if (this.domain.isServer(this.target)) {
            this.deleteServerFromLBConfig(lbconfigs, this.config, this.target);
            msg = localStrings.getLocalString("http_lb_admin.DeleteServerFromConfig", "Deleted server {0} from Lb", this.target, this.config);
            this.logger.info(msg);
        } else {
            msg = localStrings.getLocalString("InvalidTarget", "Invalid target", this.target);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }

    private void deleteServerFromLBConfig(LbConfigs lbconfigs, String configName, String serverName) {
        LbConfig lbConfig = lbconfigs.getLbConfig(configName);
        ServerRef sRef = lbConfig.getRefByRef(ServerRef.class, serverName);
        if (sRef == null) {
            String msg = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", this.target);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Server " + serverName + " does not exist in any cluster in the domain");
            }
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (!Boolean.parseBoolean(this.force)) {
            if (Boolean.parseBoolean(sRef.getLbEnabled())) {
                String msg = localStrings.getLocalString("ServerNeedsToBeDisabled", "Server [{0}] needs to be disabled before it can be removed from the load balancer.", serverName);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            Server s = this.domain.getServerNamed(serverName);
            if (s == null) {
                String msg = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            List<ApplicationRef> appRefs = this.domain.getApplicationRefsInTarget(this.target);
            if (appRefs == null) {
                String msg = localStrings.getLocalString("AppRefsNotDefined", "Application refs does not exist in server {0}", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            boolean appLbEnabled = false;
            for (ApplicationRef aRef : appRefs) {
                if (!Boolean.parseBoolean(aRef.getLbEnabled())) continue;
                appLbEnabled = true;
                break;
            }
            if (appLbEnabled) {
                String msg = localStrings.getLocalString("AppsNotDisabled", "All referenced applications must be disabled in LB");
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        this.removeServerRef(lbConfig, sRef);
    }

    private void deleteClusterFromLBConfig(LbConfigs lbconfigs, String configName, String clusterName) {
        LbConfig lbConfig = lbconfigs.getLbConfig(configName);
        ClusterRef cRef = lbConfig.getRefByRef(ClusterRef.class, clusterName);
        if (cRef == null) {
            String msg = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", this.target);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cluster " + clusterName + " does not exist.");
            }
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (!Boolean.parseBoolean(this.force)) {
            Cluster c = this.domain.getClusterNamed(clusterName);
            if (c == null) {
                String msg = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            List<ServerRef> sRefs = c.getServerRef();
            boolean refLbEnabled = false;
            for (ServerRef ref : sRefs) {
                if (!Boolean.parseBoolean(ref.getLbEnabled())) continue;
                refLbEnabled = true;
            }
            if (refLbEnabled) {
                String msg = localStrings.getLocalString("ServerNeedsToBeDisabled", "Server [{0}] needs to be disabled before it can be removed from the load balancer.", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        this.removeClusterRef(lbConfig, cRef);
    }

    public void removeServerRef(LbConfig lc, final ServerRef sRef) {
        try {
            ConfigSupport.apply(new SingleConfigCode<LbConfig>(){

                @Override
                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    param.getClusterRefOrServerRef().remove(sRef);
                    return Boolean.TRUE;
                }
            }, lc);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveServerRef", "Failed to remove server-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause(ex);
            return;
        }
    }

    public void removeClusterRef(LbConfig lc, final ClusterRef cRef) {
        try {
            ConfigSupport.apply(new SingleConfigCode<LbConfig>(){

                @Override
                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    param.getClusterRefOrServerRef().remove(cRef);
                    return Boolean.TRUE;
                }
            }, lc);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveClusterRef", "Failed to remove cluster-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause(ex);
            return;
        }
    }
}

