/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.web.deployment.descriptor.OrderingOrderingDescriptor;
import org.glassfish.web.deployment.descriptor.WebFragmentDescriptor;

public class OrderingDescriptor
extends Descriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(OrderingDescriptor.class);
    OrderingOrderingDescriptor after = null;
    OrderingOrderingDescriptor before = null;

    public OrderingOrderingDescriptor getAfter() {
        return this.after;
    }

    public void setAfter(OrderingOrderingDescriptor after) {
        this.after = after;
        this.validate();
    }

    public OrderingOrderingDescriptor getBefore() {
        return this.before;
    }

    public void setBefore(OrderingOrderingDescriptor before) {
        this.before = before;
        this.validate();
    }

    public void validate() {
        boolean valid = true;
        if (this.after != null && this.before != null) {
            if (this.after.containsOthers() && this.before.containsOthers()) {
                valid = false;
            }
            if (valid) {
                for (String name : this.after.getNames()) {
                    if (!this.before.containsName(name)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (!valid) {
            throw new IllegalStateException(localStrings.getLocalString("web.deployment.exceptioninvalidordering", "The ordering is not valid as it contains the same name and/or others in both before and after."));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.after != null) {
            builder.append("after: " + this.after + ", ");
        }
        if (this.before != null) {
            builder.append("before: " + this.before);
        }
        return builder.toString();
    }

    public static void sort(List<WebFragmentDescriptor> wfs) {
        if (wfs == null || wfs.size() <= 1) {
            return;
        }
        ArrayList<Node> graph = new ArrayList<Node>();
        HashMap<String, Node> name2NodeMap = new HashMap<String, Node>();
        Node othersNode = new Node(null);
        for (WebFragmentDescriptor wf : wfs) {
            Node wfNode = new Node(wf);
            String wfName = wf.getName();
            if (wfName != null && wfName.length() > 0) {
                name2NodeMap.put(wfName, wfNode);
            }
            graph.add(wfNode);
        }
        ArrayList remaining = new ArrayList(graph);
        HashMap<Node, Map<Node, Edge>> map = new HashMap<Node, Map<Node, Edge>>();
        for (int i = 0; i < graph.size(); ++i) {
            boolean hasBeforeOrdering;
            OrderingOrderingDescriptor before;
            Node wfNode = (Node)graph.get(i);
            WebFragmentDescriptor wf = wfNode.getWebFragmentDescriptor();
            String wfName = wf.getName();
            OrderingDescriptor od = wf.getOrderingDescriptor();
            if (od == null) continue;
            OrderingOrderingDescriptor after = od.getAfter();
            if (after != null) {
                if (after.containsOthers()) {
                    wfNode.getInEdges().add(OrderingDescriptor.getEdge(othersNode, wfNode, map));
                    othersNode.getOutEdges().add(OrderingDescriptor.getEdge(othersNode, wfNode, map));
                    remaining.remove(othersNode);
                }
                for (String string : after.getNames()) {
                    Node nameNode = (Node)name2NodeMap.get(string);
                    if (nameNode == null) continue;
                    wfNode.getInEdges().add(OrderingDescriptor.getEdge(nameNode, wfNode, map));
                    nameNode.getOutEdges().add(OrderingDescriptor.getEdge(nameNode, wfNode, map));
                    remaining.remove(nameNode);
                }
            }
            if ((before = od.getBefore()) != null) {
                if (before.containsOthers()) {
                    wfNode.getOutEdges().add(OrderingDescriptor.getEdge(wfNode, othersNode, map));
                    othersNode.getInEdges().add(OrderingDescriptor.getEdge(wfNode, othersNode, map));
                    remaining.remove(othersNode);
                }
                for (String name2 : before.getNames()) {
                    Node nameNode = (Node)name2NodeMap.get(name2);
                    if (nameNode == null) continue;
                    wfNode.getOutEdges().add(OrderingDescriptor.getEdge(wfNode, nameNode, map));
                    nameNode.getInEdges().add(OrderingDescriptor.getEdge(wfNode, nameNode, map));
                    remaining.remove(nameNode);
                }
            }
            boolean bl = after != null && (after.containsOthers() || after.getNames().size() > 0);
            boolean bl2 = hasBeforeOrdering = before != null && (before.containsOthers() || before.getNames().size() > 0);
            if (!bl && !hasBeforeOrdering) continue;
            remaining.remove(wfNode);
        }
        if (othersNode.getOutEdges().size() > 0 || othersNode.getInEdges().size() > 0) {
            graph.add(othersNode);
            Stack<Node> afterOthersStack = new Stack<Node>();
            for (Iterator edge : othersNode.getOutEdges()) {
                ((Edge)((Object)edge)).setVisited(true);
                afterOthersStack.push(((Edge)((Object)edge)).getToNode());
            }
            while (!afterOthersStack.isEmpty()) {
                Node aNode = (Node)afterOthersStack.pop();
                aNode.setAfterOthers(true);
                for (Object edge : aNode.getOutEdges()) {
                    if (((Edge)edge).isVisited()) continue;
                    afterOthersStack.push(((Edge)edge).getToNode());
                    ((Edge)edge).setVisited(true);
                }
            }
            Stack<Node> beforeOthersStack = new Stack<Node>();
            for (Object edge : othersNode.getInEdges()) {
                ((Edge)edge).setVisited(true);
                beforeOthersStack.push(((Edge)edge).getFromNode());
            }
            while (!beforeOthersStack.isEmpty()) {
                Node aNode = (Node)beforeOthersStack.pop();
                aNode.setBeforeOthers(true);
                for (Edge edge : aNode.getInEdges()) {
                    if (edge.isVisited()) continue;
                    beforeOthersStack.push(edge.getFromNode());
                    edge.setVisited(true);
                }
            }
        }
        ArrayList<Node> subgraph = new ArrayList<Node>(graph);
        subgraph.removeAll(remaining);
        boolean hasRemaining = remaining.size() > 0;
        List<Node> sortedNodes = OrderingDescriptor.topologicalSort(subgraph, hasRemaining);
        wfs.clear();
        boolean othersProcessed = false;
        for (Node node : sortedNodes) {
            if (node.isOthers()) {
                othersProcessed = true;
                for (Node node2 : remaining) {
                    wfs.add(node2.getWebFragmentDescriptor());
                }
                continue;
            }
            wfs.add(node.getWebFragmentDescriptor());
        }
        if (!othersProcessed) {
            for (Node rnode : remaining) {
                wfs.add(rnode.getWebFragmentDescriptor());
            }
        }
    }

    private static Edge getEdge(Node from, Node to, Map<Node, Map<Node, Edge>> map) {
        Edge edge = null;
        Map<Node, Edge> node2Edge = map.get(from);
        if (node2Edge == null) {
            node2Edge = new HashMap<Node, Edge>();
            map.put(from, node2Edge);
        } else {
            edge = node2Edge.get(to);
        }
        if (edge == null) {
            edge = new Edge(from, to);
            node2Edge.put(to, edge);
        }
        return edge;
    }

    private static List<Node> topologicalSort(List<Node> graph, boolean hasRemaining) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>();
        if (graph.size() == 0) {
            return sortedNodes;
        }
        Stack<Node> roots = new Stack<Node>();
        Stack<Node> rootsBefore = new Stack<Node>();
        Stack<Node> rootsAfter = new Stack<Node>();
        for (Node node : graph) {
            if (node.getInEdges().size() != 0) continue;
            if (node.isBeforeOthers()) {
                rootsBefore.add(node);
                continue;
            }
            if (node.isAfterOthers() || node.isOthers()) {
                rootsAfter.add(node);
                continue;
            }
            roots.add(node);
        }
        if (roots.empty() && rootsBefore.empty() && rootsAfter.empty()) {
            if (OrderingDescriptor.isCircleWithOthersAndNoRemaining(graph, hasRemaining, sortedNodes)) {
                return sortedNodes;
            }
            throw new IllegalStateException(localStrings.getLocalString("web.deployment.exceptioninvalidwebfragmentordering", "The web fragment ordering is not valid and possibly has cycling conflicts."));
        }
        while (!(roots.empty() && rootsBefore.empty() && rootsAfter.empty())) {
            Node node = null;
            node = !rootsBefore.empty() ? (Node)rootsBefore.pop() : (!roots.empty() ? (Node)roots.pop() : (Node)rootsAfter.pop());
            sortedNodes.add(node);
            Iterator outEdgesIter = node.getOutEdges().iterator();
            while (outEdgesIter.hasNext()) {
                Edge outEdge = (Edge)outEdgesIter.next();
                Node outNode = outEdge.getToNode();
                outEdgesIter.remove();
                outNode.getInEdges().remove(outEdge);
                if (outNode.getInEdges().size() != 0) continue;
                if (node.isBeforeOthers()) {
                    rootsBefore.add(outNode);
                    continue;
                }
                if (node.isAfterOthers() || node.isOthers()) {
                    rootsAfter.add(outNode);
                    continue;
                }
                roots.add(outNode);
            }
        }
        boolean hasEdges = false;
        for (Node node : graph) {
            if (node.getInEdges().size() <= 0 && node.getOutEdges().size() <= 0) continue;
            hasEdges = true;
            break;
        }
        if (hasEdges) {
            throw new IllegalStateException(localStrings.getLocalString("web.deployment.exceptioninvalidwebfragmentordering", "The web fragment ordering is not valid and possibly has cycling conflicts."));
        }
        return sortedNodes;
    }

    private static boolean isCircleWithOthersAndNoRemaining(List<Node> graph, boolean hasRemaining, List<Node> sortedNodes) {
        boolean circleWithOthersAndNoRemaining = false;
        int size = graph.size();
        if (size == 0 || hasRemaining) {
            return circleWithOthersAndNoRemaining;
        }
        Node nextNode = graph.get(size - 1);
        if (nextNode.isOthers()) {
            LinkedHashSet<Node> set = new LinkedHashSet<Node>();
            for (int count = 0; count < size && nextNode.getOutEdges().size() == 1 && nextNode.getInEdges().size() == 1 && set.add(nextNode); ++count) {
                nextNode = ((Edge)nextNode.getOutEdges().iterator().next()).getToNode();
            }
            if (set.size() == size) {
                circleWithOthersAndNoRemaining = true;
                Iterator iter = set.iterator();
                if (iter.hasNext()) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    sortedNodes.add((Node)iter.next());
                }
            }
        }
        return circleWithOthersAndNoRemaining;
    }

    private static void print(WebFragmentDescriptor wf, String nullWfString, StringBuilder sb) {
        String wfName = null;
        wfName = wf != null ? wf.getName() : nullWfString;
        sb.append(wfName);
    }

    private static final class Edge {
        private Node fromNode = null;
        private Node toNode = null;
        private boolean visited = false;

        private Edge(Node from, Node to) {
            this.fromNode = from;
            this.toNode = to;
        }

        private Node getFromNode() {
            return this.fromNode;
        }

        private Node getToNode() {
            return this.toNode;
        }

        private boolean isVisited() {
            return this.visited;
        }

        private void setVisited(boolean vt) {
            this.visited = vt;
        }
    }

    private static class Node {
        private WebFragmentDescriptor webFragmentDescriptor = null;
        private Set<Edge> inEdges = new LinkedHashSet<Edge>();
        private Set<Edge> outEdges = new LinkedHashSet<Edge>();
        private boolean afterOthers = false;
        private boolean beforeOthers = false;

        private Node(WebFragmentDescriptor wf) {
            this.webFragmentDescriptor = wf;
        }

        private WebFragmentDescriptor getWebFragmentDescriptor() {
            return this.webFragmentDescriptor;
        }

        private Set<Edge> getInEdges() {
            return this.inEdges;
        }

        private Set<Edge> getOutEdges() {
            return this.outEdges;
        }

        private boolean isOthers() {
            return this.webFragmentDescriptor == null;
        }

        private boolean isAfterOthers() {
            return this.afterOthers;
        }

        private void setAfterOthers(boolean afterOthers) {
            this.afterOthers = afterOthers;
        }

        private boolean isBeforeOthers() {
            return this.beforeOthers;
        }

        private void setBeforeOthers(boolean beforeOthers) {
            this.beforeOthers = beforeOthers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{name=");
            OrderingDescriptor.print(this.webFragmentDescriptor, "@others", sb);
            sb.append(", inNodes=[");
            boolean first = true;
            for (Edge e : this.inEdges) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                OrderingDescriptor.print(e.getFromNode().getWebFragmentDescriptor(), "@others", sb);
            }
            sb.append("]");
            sb.append(", outNodes=[");
            first = true;
            for (Edge e : this.outEdges) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                OrderingDescriptor.print(e.getToNode().getWebFragmentDescriptor(), "@others", sb);
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

