/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.util.reflection.Reflections;

public class SlimAnnotatedTypeStoreImpl
extends AbstractBootstrapService
implements SlimAnnotatedTypeStore {
    private final LoadingCache<Class<?>, Set<SlimAnnotatedType<?>>> typesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Set<SlimAnnotatedType<?>>>(){

        @Override
        public Set<SlimAnnotatedType<?>> load(Class<?> input) {
            return new CopyOnWriteArraySet();
        }
    });

    @Override
    public <X> SlimAnnotatedType<X> get(Class<X> type2, String suffix) {
        for (SlimAnnotatedType annotatedType : this.get((Class)type2)) {
            if (!Objects.equal(((AnnotatedTypeIdentifier)annotatedType.getIdentifier()).getSuffix(), suffix)) continue;
            return annotatedType;
        }
        return null;
    }

    public <X> Set<SlimAnnotatedType<X>> get(Class<X> type2) {
        return (Set)Reflections.cast(Collections.unmodifiableSet(this.typesByClass.getUnchecked(type2)));
    }

    @Override
    public <X> void put(SlimAnnotatedType<X> type2) {
        this.typesByClass.getUnchecked(type2.getJavaClass()).add(type2);
    }

    @Override
    public void cleanupAfterBoot() {
        this.typesByClass.invalidateAll();
    }
}

