/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.TypeClosureLazyValueHolder;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.WeldCollections;

public class SharedObjectCache
implements BootstrapService {
    private final LoadingCache<Set<?>, Set<?>> sharedSets = CacheBuilder.newBuilder().build(new CacheLoader<Set<?>, Set<?>>(){

        @Override
        public Set<?> load(Set<?> from) {
            return WeldCollections.immutableSet(from);
        }
    });
    private final LoadingCache<Map<?, ?>, Map<?, ?>> sharedMaps = CacheBuilder.newBuilder().build(new CacheLoader<Map<?, ?>, Map<?, ?>>(){

        @Override
        public Map<?, ?> load(Map<?, ?> from) {
            return WeldCollections.immutableMap(from);
        }
    });
    private final LoadingCache<Type, LazyValueHolder<Set<Type>>> typeClosureHolders = CacheBuilder.newBuilder().build(new CacheLoader<Type, LazyValueHolder<Set<Type>>>(){

        @Override
        public LazyValueHolder<Set<Type>> load(Type input) {
            return new TypeClosureLazyValueHolder(input);
        }
    });

    public static SharedObjectCache instance(BeanManagerImpl manager) {
        return manager.getServices().get(SharedObjectCache.class);
    }

    public <T> Set<T> getSharedSet(Set<T> set) {
        return (Set)LoadingCacheUtils.getCastCacheValue(this.sharedSets, set);
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map) {
        return (Map)LoadingCacheUtils.getCastCacheValue(this.sharedMaps, map);
    }

    public LazyValueHolder<Set<Type>> getTypeClosureHolder(Type type2) {
        return LoadingCacheUtils.getCacheValue(this.typeClosureHolders, type2);
    }

    @Override
    public void cleanupAfterBoot() {
        this.sharedSets.invalidateAll();
        this.sharedMaps.invalidateAll();
        this.typeClosureHolders.invalidateAll();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
    }
}

