/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.util.KeyTransformer;
import org.shoal.ha.cache.impl.util.ObjectInputStreamWithLoader;

public class DefaultKeyTransformer<K>
implements KeyTransformer<K> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache");
    private ClassLoader loader;

    public DefaultKeyTransformer(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public byte[] keyToByteArray(K k) {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(k);
            try {
                oos.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            byte[] ex = bos.toByteArray();
            return ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ObjectOutputStream");
            }
            try {
                bos.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ByteArrayOutputStream");
            }
        }
    }

    @Override
    public K byteArrayToKey(byte[] bytes, int index, int len) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, index, len);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStreamWithLoader(bis, this.loader);
            Object object = ois.readObject();
            return (K)object;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ObjectInputStream");
            }
            try {
                bis.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Ignorable error while closing ByteArrayInputStream");
            }
        }
    }
}

