
package org.glassfish.admingui.connector;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;

@Service(name = "Module", metadata = "target=org.glassfish.admingui.connector.GadgetModule,<UserPref>=collection:org.glassfish.admingui.connector.GadgetUserPref,<ModulePrefs>=org.glassfish.admingui.connector.GadgetModulePrefs,<Content>=leaf")
@InjectionTarget(GadgetModule.class)
public class GadgetModuleInjector
    extends ConfigInjector<GadgetModule>
{


    public void inject(Dom dom, GadgetModule target) {
        element_setGadgetUserPref(dom, target);
        element_setGadgetModulePrefs(dom, target);
        element_setText(dom, target);
    }

    public void injectAttribute(Dom dom, String name, GadgetModule target) {
    }

    public void injectElement(Dom dom, String name, GadgetModule target) {
        if ("UserPref".equals(name)) {
            element_setGadgetUserPref(dom, target);
        }
        if ("ModulePrefs".equals(name)) {
            element_setGadgetModulePrefs(dom, target);
        }
        if ("Content".equals(name)) {
            element_setText(dom, target);
        }
    }

    public void element_setGadgetUserPref(Dom dom, GadgetModule target) {
        List<Dom> v1 = dom.nodeElements("UserPref");
        if (v1 == null) {
            return ;
        }
        List v2 = new ArrayList<org.glassfish.admingui.connector.GadgetUserPref>(v1 .size());
        for (Dom v3 : v1) {
            v2 .add(((org.glassfish.admingui.connector.GadgetUserPref) v3 .get()));
        }
        target.setGadgetUserPref(v2);
    }

    public void element_setGadgetModulePrefs(Dom dom, GadgetModule target) {
        Dom v1 = dom.nodeElement("ModulePrefs");
        if (v1 == null) {
            return ;
        }
        target.setGadgetModulePrefs(((GadgetModulePrefs) v1 .get()));
    }

    public void element_setText(Dom dom, GadgetModule target) {
        String v1 = dom.leafElement("Content");
        if (v1 == null) {
            return ;
        }
        target.setText(v1);
    }

}
