
package org.glassfish.admingui.connector;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;

@Service(name = "index", metadata = "target=org.glassfish.admingui.connector.Index,<indexitem>=collection:org.glassfish.admingui.connector.IndexItem,@version=required,@version=datatype:java.lang.String,@version=leaf")
@InjectionTarget(Index.class)
public class IndexInjector
    extends ConfigInjector<Index>
{


    public void inject(Dom dom, Index target) {
        element_setIndexItems(dom, target);
        attribute_setVersion(dom, target);
    }

    public void injectAttribute(Dom dom, String name, Index target) {
        if ("version".equals(name)) {
            attribute_setVersion(dom, target);
        }
    }

    public void injectElement(Dom dom, String name, Index target) {
        if ("indexitem".equals(name)) {
            element_setIndexItems(dom, target);
        }
    }

    public void element_setIndexItems(Dom dom, Index target) {
        List<Dom> v1 = dom.nodeElements("indexitem");
        if (v1 == null) {
            return ;
        }
        List v2 = new ArrayList<org.glassfish.admingui.connector.IndexItem>(v1 .size());
        for (Dom v3 : v1) {
            v2 .add(((org.glassfish.admingui.connector.IndexItem) v3 .get()));
        }
        target.setIndexItems(v2);
    }

    public void attribute_setVersion(Dom dom, Index target) {
        String v1 = dom.attribute("version");
        target.setVersion(v1);
    }

}
