/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2006-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.contextpropagation;

import java.util.EnumSet;

import org.glassfish.contextpropagation.bootstrap.ContextBootstrap;

/**
 * The Location class provides information about the current location of the 
 * request relative to the point where it originally entered the system. As
 * the request hops from one region of the system to the next (from thread to 
 * thread or from process to process) the Location is updated to reflect the
 * changes in location.
 *
 */
public class Location implements ViewCapable, ContextLifecycle {
  public static final EnumSet<PropagationMode> PROP_MODES = PropagationMode.defaultSetOneway();
  private View view;
  public static final String KEY = "org.glassfish.contextpropagation.Location";
  private String origin;
  private String locationId;
  private short lastChildId = 0;
  
  /*
   * Implemented as a ViewCapable custom context so that Location may be 
   * propagated
   */
  protected Location(View aView) {
    view = aView;
  }
  
  /**
   * @return The original unique identifier for the request. This identifier
   * is generated by the process where the request was originally submitted.
   */
  public String getOrigin() {
    return origin == null ? ContextBootstrap.getGuid() : origin; 
  }
  
  /* For future implementation public short[] getBreadCrumbs() {
  } provides a more compact way of representing the location id*/
  
  /**
   * @return a unique String illustrating the shortest path between 
   * the original location where
   * the request entered the system and current location.
   */
  public String getLocationId() {
    return "[" + getLocationIdInternal() + "]";
  }
  
  private String getLocationIdInternal() {
    return locationId == null ? "0" : locationId; 
  }

  @Override
  public void contextChanged(Object replacementContext) { /* NO-OP */ }

  @Override
  public void contextAdded() {
    origin = view.get("origin");
    view.put("origin", getOrigin(), PROP_MODES);
    locationId = view.get("locationId");
  }

  @Override
  public void contextRemoved() { /* NO-OP */}

  @Override
  public ViewCapable contextToPropagate() {
    view.put("locationId", getLocationIdInternal() + ", " + ++lastChildId, PROP_MODES);
    return this;
  }
  
  // For future implementation public short[] getTravelLog(); Provides the full
  // itinerary followed by the request
}
