/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.operations;

import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

public final class UnlockIfLeaseExpiredOperation
extends UnlockOperation {
    private final int version;

    public UnlockIfLeaseExpiredOperation(ObjectNamespace namespace, Data key, int version) {
        super(namespace, key, -1L, true);
        this.version = version;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        int lockVersion = lockStore.getVersion(this.key);
        if (this.version == lockVersion) {
            this.forceUnlock();
        } else {
            ILogger logger2 = this.getLogger();
            if (logger2.isFinestEnabled()) {
                logger2.finest("Won't unlock since lock version is not matching expiration version: " + lockVersion + " vs " + this.version);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException("This operation is intended to be executed on local member only!");
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException("This operation is intended to be executed on local member only!");
    }
}

