/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.config.MapConfig;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.DefaultRecordStore;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapKeyLoaderUtil;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionContainer {
    private final MapService mapService;
    private final int partitionId;
    private final ConcurrentMap<String, RecordStore> maps = new ConcurrentHashMap<String, RecordStore>(1000);
    private final ConstructorFunction<String, RecordStore> recordStoreConstructor = new ConstructorFunction<String, RecordStore>(){

        @Override
        public RecordStore createNew(String name) {
            MapServiceContext serviceContext = PartitionContainer.this.mapService.getMapServiceContext();
            MapContainer mapContainer = serviceContext.getMapContainer(name);
            MapConfig mapConfig = mapContainer.getMapConfig();
            NodeEngine nodeEngine = serviceContext.getNodeEngine();
            InternalPartitionService ps = nodeEngine.getPartitionService();
            OperationService opService = nodeEngine.getOperationService();
            ExecutionService execService = nodeEngine.getExecutionService();
            GroupProperties groupProperties = nodeEngine.getGroupProperties();
            MapKeyLoader keyLoader = new MapKeyLoader(name, opService, ps, execService, mapContainer.toData());
            keyLoader.setMaxBatch(groupProperties.MAP_LOAD_CHUNK_SIZE.getInteger());
            keyLoader.setMaxSize(MapKeyLoaderUtil.getMaxSizePerNode(mapConfig.getMaxSizeConfig()));
            keyLoader.setHasBackup(mapConfig.getBackupCount() > 0 || mapConfig.getAsyncBackupCount() > 0);
            ILogger logger2 = nodeEngine.getLogger(DefaultRecordStore.class);
            DefaultRecordStore recordStore = new DefaultRecordStore(mapContainer, PartitionContainer.this.partitionId, keyLoader, logger2);
            recordStore.startLoading();
            return recordStore;
        }
    };
    private volatile boolean hasRunningCleanup;
    private volatile long lastCleanupTime;
    private long lastCleanupTimeCopy;

    public PartitionContainer(MapService mapService, int partitionId) {
        this.mapService = mapService;
        this.partitionId = partitionId;
    }

    public ConcurrentMap<String, RecordStore> getMaps() {
        return this.maps;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MapService getMapService() {
        return this.mapService;
    }

    public RecordStore getRecordStore(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this, this.recordStoreConstructor);
    }

    public RecordStore getExistingRecordStore(String mapName) {
        return (RecordStore)this.maps.get(mapName);
    }

    public void destroyMap(String name) {
        RecordStore recordStore = (RecordStore)this.maps.remove(name);
        if (recordStore != null) {
            recordStore.clearPartition();
        } else {
            this.clearLockStore(name);
        }
    }

    private void clearLockStore(String name) {
        NodeEngine nodeEngine = this.mapService.getMapServiceContext().getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }

    void clear() {
        for (RecordStore recordStore : this.maps.values()) {
            recordStore.clearPartition();
        }
        this.maps.clear();
    }

    public boolean hasRunningCleanup() {
        return this.hasRunningCleanup;
    }

    public void setHasRunningCleanup(boolean hasRunningCleanup) {
        this.hasRunningCleanup = hasRunningCleanup;
    }

    public long getLastCleanupTime() {
        return this.lastCleanupTime;
    }

    public void setLastCleanupTime(long lastCleanupTime) {
        this.lastCleanupTime = lastCleanupTime;
    }

    public long getLastCleanupTimeCopy() {
        return this.lastCleanupTimeCopy;
    }

    public void setLastCleanupTimeCopy(long lastCleanupTimeCopy) {
        this.lastCleanupTimeCopy = lastCleanupTimeCopy;
    }
}

