/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableSerializer;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultPortableReader
implements PortableReader {
    private static final Pattern NESTED_FIELD_PATTERN = Pattern.compile("\\.");
    protected final ClassDefinition cd;
    protected final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int finalPosition;
    private final int offset;
    private boolean raw;

    public DefaultPortableReader(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd) {
        int fieldCount;
        this.in = in;
        this.serializer = serializer;
        this.cd = cd;
        try {
            this.finalPosition = in.readInt();
            fieldCount = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        if (fieldCount != cd.getFieldCount()) {
            throw new IllegalStateException("Field count[" + fieldCount + "] in stream does not match " + cd);
        }
        this.offset = in.position();
    }

    @Override
    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    public FieldType getFieldType(String fieldName) {
        return this.cd.getFieldType(fieldName);
    }

    @Override
    public int getFieldClassId(String fieldName) {
        return this.cd.getFieldClassId(fieldName);
    }

    @Override
    public int readInt(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.INT);
        return this.in.readInt(pos);
    }

    @Override
    public long readLong(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.LONG);
        return this.in.readLong(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUTF(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF);
            this.in.position(pos);
            String string = this.in.readUTF();
            return string;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public boolean readBoolean(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.BOOLEAN);
        return this.in.readBoolean(pos);
    }

    @Override
    public byte readByte(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.BYTE);
        return this.in.readByte(pos);
    }

    @Override
    public char readChar(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.CHAR);
        return this.in.readChar(pos);
    }

    @Override
    public double readDouble(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.DOUBLE);
        return this.in.readDouble(pos);
    }

    @Override
    public float readFloat(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.FLOAT);
        return this.in.readFloat(pos);
    }

    @Override
    public short readShort(String fieldName) throws IOException {
        int pos = this.readPosition(fieldName, FieldType.SHORT);
        return this.in.readShort(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readByteArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
            this.in.position(pos);
            byte[] byArray = this.in.readByteArray();
            return byArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] readCharArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
            this.in.position(pos);
            char[] cArray = this.in.readCharArray();
            return cArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] readIntArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.INT_ARRAY);
            this.in.position(pos);
            int[] nArray = this.in.readIntArray();
            return nArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] readLongArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.LONG_ARRAY);
            this.in.position(pos);
            long[] lArray = this.in.readLongArray();
            return lArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] readDoubleArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
            this.in.position(pos);
            double[] dArray = this.in.readDoubleArray();
            return dArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] readFloatArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
            this.in.position(pos);
            float[] fArray = this.in.readFloatArray();
            return fArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] readShortArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
            this.in.position(pos);
            short[] sArray = this.in.readShortArray();
            return sArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portable readPortable(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE) {
                throw new HazelcastSerializationException("Not a Portable field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            if (!isNull) {
                Portable portable = this.serializer.readAndInitialize(this.in, factoryId, classId);
                return portable;
            }
            Portable portable = null;
            return portable;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Portable[] readPortableArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            int len = this.in.readInt();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            Portable[] portables = new Portable[len];
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    portables[i] = this.serializer.readAndInitialize(this.in, factoryId, classId);
                }
            }
            Portable[] portableArray = portables;
            return portableArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private void checkFactoryAndClass(FieldDefinition fd, int factoryId, int classId) {
        if (factoryId != fd.getFactoryId()) {
            throw new IllegalArgumentException("Invalid factoryId! Expected: " + fd.getFactoryId() + ", Current: " + factoryId);
        }
        if (classId != fd.getClassId()) {
            throw new IllegalArgumentException("Invalid classId! Expected: " + fd.getClassId() + ", Current: " + classId);
        }
    }

    private HazelcastSerializationException throwUnknownFieldException(String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    private int readPosition(String fieldName, FieldType type2) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot read Portable fields after getRawDataInput() is called!");
        }
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return this.readNestedPosition(fieldName, type2);
        }
        if (fd.getType() != type2) {
            throw new HazelcastSerializationException("Not a '" + (Object)((Object)type2) + "' field: " + fieldName);
        }
        return this.readPosition(fd);
    }

    private int readNestedPosition(String fieldName, FieldType type2) throws IOException {
        String[] fieldNames = NESTED_FIELD_PATTERN.split(fieldName);
        if (fieldNames.length > 1) {
            FieldDefinition fd = null;
            DefaultPortableReader reader = this;
            for (int i = 0; i < fieldNames.length && (fd = reader.cd.getField(fieldNames[i])) != null && i != fieldNames.length - 1; ++i) {
                int pos = reader.readPosition(fd);
                this.in.position(pos);
                boolean isNull = this.in.readBoolean();
                if (isNull) {
                    throw new NullPointerException("Parent field is null: " + fieldNames[i]);
                }
                reader = this.serializer.createReader(this.in);
            }
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != type2) {
                throw new HazelcastSerializationException("Not a '" + (Object)((Object)type2) + "' field: " + fieldName);
            }
            return reader.readPosition(fd);
        }
        throw this.throwUnknownFieldException(fieldName);
    }

    private int readPosition(FieldDefinition fd) throws IOException {
        int pos = this.in.readInt(this.offset + fd.getIndex() * 4);
        short len = this.in.readShort(pos);
        return pos + 2 + len + 1;
    }

    @Override
    public ObjectDataInput getRawDataInput() throws IOException {
        if (!this.raw) {
            int pos = this.in.readInt(this.offset + this.cd.getFieldCount() * 4);
            this.in.position(pos);
        }
        this.raw = true;
        return this.in;
    }

    final void end() throws IOException {
        this.in.position(this.finalPosition);
    }
}

