/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.spi.TaggedJobExecution;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class JobOperatorJobExecution
implements IJobExecution,
TaggedJobExecution {
    private static final String sourceClass = JobOperatorJobExecution.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private static IPersistenceManagerService _persistenceManagementService = servicesManager.getPersistenceManagerService();
    private long executionID = 0L;
    private long instanceID = 0L;
    Timestamp createTime;
    Timestamp startTime;
    Timestamp endTime;
    Timestamp updateTime;
    Properties parameters;
    String batchStatus;
    BatchStatus cachedBatchStatus;
    String exitStatus;
    String cachedExitStatus;
    Properties jobProperties = null;
    String jobName = null;
    private JobContextImpl jobContext = null;
    private static final boolean cacheFirstStatus = Boolean.getBoolean("JobExecution.cache.first.status");

    public JobOperatorJobExecution(long executionId, long instanceId) {
        this.executionID = executionId;
        this.instanceID = instanceId;
        if (cacheFirstStatus) {
            this.cachedBatchStatus = this.getCurrentBatchStatus();
            this.cachedExitStatus = this.getCurrentExitStatus();
        }
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public void setJobContext(JobContextImpl jobContext) {
        this.jobContext = jobContext;
    }

    @Override
    public BatchStatus getBatchStatus() {
        if (cacheFirstStatus) {
            return this.cachedBatchStatus;
        }
        return this.getCurrentBatchStatus();
    }

    @Override
    public String getExitStatus() {
        if (cacheFirstStatus) {
            return this.cachedExitStatus;
        }
        return this.getCurrentExitStatus();
    }

    public BatchStatus getCurrentBatchStatus() {
        BatchStatus batchStatusEnum = null;
        if (this.jobContext != null) {
            batchStatusEnum = this.jobContext.getBatchStatus();
            logger.finest("Returning batch status of: " + this.batchStatus + " from JobContext.");
        } else {
            batchStatusEnum = BatchStatus.valueOf(_persistenceManagementService.jobOperatorQueryJobExecutionBatchStatus(this.executionID));
            logger.finest("Returning batch status of: " + this.batchStatus + " from JobContext.");
        }
        return batchStatusEnum;
    }

    @Override
    public Date getCreateTime() {
        if (this.jobContext == null) {
            this.createTime = _persistenceManagementService.jobOperatorQueryJobExecutionTimestamp(this.executionID, IPersistenceManagerService.TimestampType.CREATE);
        }
        if (this.createTime != null) {
            return new Date(this.createTime.getTime());
        }
        return this.createTime;
    }

    @Override
    public Date getEndTime() {
        if (this.jobContext == null) {
            this.endTime = _persistenceManagementService.jobOperatorQueryJobExecutionTimestamp(this.executionID, IPersistenceManagerService.TimestampType.END);
        }
        if (this.endTime != null) {
            return new Date(this.endTime.getTime());
        }
        return this.endTime;
    }

    @Override
    public long getExecutionId() {
        return this.executionID;
    }

    public String getCurrentExitStatus() {
        if (this.jobContext != null) {
            return this.jobContext.getExitStatus();
        }
        this.exitStatus = _persistenceManagementService.jobOperatorQueryJobExecutionExitStatus(this.executionID);
        return this.exitStatus;
    }

    @Override
    public Date getLastUpdatedTime() {
        if (this.jobContext == null) {
            this.updateTime = _persistenceManagementService.jobOperatorQueryJobExecutionTimestamp(this.executionID, IPersistenceManagerService.TimestampType.LAST_UPDATED);
        }
        if (this.updateTime != null) {
            return new Date(this.updateTime.getTime());
        }
        return this.updateTime;
    }

    @Override
    public Date getStartTime() {
        if (this.jobContext == null) {
            this.startTime = _persistenceManagementService.jobOperatorQueryJobExecutionTimestamp(this.executionID, IPersistenceManagerService.TimestampType.STARTED);
        }
        if (this.startTime != null) {
            return new Date(this.startTime.getTime());
        }
        return this.startTime;
    }

    @Override
    public Properties getJobParameters() {
        return this.jobProperties;
    }

    @Override
    public void setBatchStatus(String status) {
        this.batchStatus = status;
    }

    @Override
    public void setCreateTime(Timestamp ts) {
        this.createTime = ts;
    }

    @Override
    public void setEndTime(Timestamp ts) {
        this.endTime = ts;
    }

    public void setExecutionId(long id) {
        this.executionID = id;
    }

    public void setJobInstanceId(long jobInstanceID) {
        this.instanceID = jobInstanceID;
    }

    @Override
    public void setExitStatus(String status) {
        this.exitStatus = status;
    }

    public void setInstanceId(long id) {
        this.instanceID = id;
    }

    @Override
    public void setLastUpdateTime(Timestamp ts) {
        this.updateTime = ts;
    }

    @Override
    public void setStartTime(Timestamp ts) {
        this.startTime = ts;
    }

    @Override
    public void setJobParameters(Properties jProps) {
        this.jobProperties = jProps;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getTagName() {
        return _persistenceManagementService.getTagName(this.executionID);
    }

    @Override
    public long getInstanceId() {
        return this.instanceID;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("createTime=" + this.createTime);
        buf.append(",batchStatus=" + this.batchStatus);
        buf.append(",exitStatus=" + this.exitStatus);
        buf.append(",jobName=" + this.jobName);
        buf.append(",instanceId=" + this.instanceID);
        buf.append(",executionId=" + this.executionID);
        return buf.toString();
    }
}

