/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ModelResolver;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.util.JSLValidationEventHandler;
import com.ibm.jbatch.jsl.util.ValidatorHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class JobModelResolverImpl
implements ModelResolver<JSLJob> {
    private static HashMap<String, JSLJob> jobid2InstanceMap = new HashMap();
    private static HashMap<String, Step> stepid2InstanceMap = new HashMap();

    private JSLJob unmarshalJobXML(String jobXML) {
        Object result = null;
        JSLJob job = null;
        JSLValidationEventHandler handler = new JSLValidationEventHandler();
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)"com.ibm.jbatch.jsl.model");
            Unmarshaller u = ctx.createUnmarshaller();
            u.setSchema(ValidatorHelper.getXJCLSchema());
            u.setEventHandler((ValidationEventHandler)handler);
            result = u.unmarshal((Source)new StreamSource(new StringReader(jobXML)));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Exception unmarshalling jobXML", e);
        }
        if (handler.eventOccurred()) {
            throw new IllegalArgumentException("xJCL invalid per schema");
        }
        job = (JSLJob)((JAXBElement)result).getValue();
        return job;
    }

    private JSLJob getJslJobInheritance(String jobId) throws IOException {
        JSLJob jslJob = null;
        InputStream indexFileUrl = JobModelResolverImpl.class.getResourceAsStream("/META-INF/jobinheritance");
        if (indexFileUrl != null) {
            Properties index = new Properties();
            index.load(indexFileUrl);
            if (index.getProperty(jobId) != null) {
                URL parentUrl = JobModelResolverImpl.class.getResource(index.getProperty(jobId));
                String parentXml = this.readJobXML(parentUrl.getFile());
                jslJob = this.resolveModel(parentXml);
            }
        }
        return jslJob;
    }

    private String readJobXML(String fileWithPath) throws FileNotFoundException, IOException {
        StringBuffer jobXMLBuffer;
        StringBuffer stringBuffer = jobXMLBuffer = fileWithPath == null ? null : new StringBuffer();
        if (fileWithPath != null) {
            BufferedReader zin = new BufferedReader(new FileReader(new File(fileWithPath)));
            String input = zin.readLine();
            do {
                if (input == null) continue;
                jobXMLBuffer.append(input);
                input = zin.readLine();
            } while (input != null);
        }
        return jobXMLBuffer == null ? null : jobXMLBuffer.toString();
    }

    @Override
    public JSLJob resolveModel(String jobXML) {
        final String finalJobXML = jobXML;
        JSLJob jslJob = AccessController.doPrivileged(new PrivilegedAction<JSLJob>(){

            @Override
            public JSLJob run() {
                return JobModelResolverImpl.this.unmarshalJobXML(finalJobXML);
            }
        });
        return jslJob;
    }

    @Override
    public JSLJob resolveModel(JSLJob t) {
        return null;
    }
}

