/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.util.Utility;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
public class EjbNamingReferenceManagerImpl
implements EjbNamingReferenceManager {
    private static final String CORBANAME = "corbaname:";
    @Inject
    InvocationManager invMgr;
    @Inject
    Provider<GlassFishORBHelper> glassFishORBHelperProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolveEjbReference(EjbReferenceDescriptor ejbRefDesc, Context context) throws NamingException {
        Object jndiObj = null;
        boolean resolved = false;
        if (ejbRefDesc.isLocal()) {
            if (ejbRefDesc.hasLookupName()) {
                jndiObj = context.lookup(ejbRefDesc.getLookupName());
                resolved = true;
            }
        } else if (!ejbRefDesc.hasJndiName() && ejbRefDesc.hasLookupName()) {
            try {
                jndiObj = context.lookup(ejbRefDesc.getLookupName());
            }
            catch (NamingException e) {
                ClassLoader oldLoader = null;
                try {
                    oldLoader = Utility.setContextClassLoader(ejbRefDesc.getReferringBundleDescriptor().getClassLoader());
                    jndiObj = context.lookup(ejbRefDesc.getLookupName());
                }
                catch (Throwable throwable) {
                    Utility.setContextClassLoader(oldLoader);
                    throw throwable;
                }
                Utility.setContextClassLoader(oldLoader);
            }
            resolved = true;
        } else if (ejbRefDesc.hasJndiName() && ejbRefDesc.getJndiName().startsWith("java:app/") && !ejbRefDesc.getJndiName().startsWith("java:app/env/")) {
            String remoteJndiName = ejbRefDesc.getJndiName();
            String appName = (String)context.lookup("java:app/AppName");
            String newPrefix = "java:global/" + appName + "/";
            int javaAppLength = "java:app/".length();
            String globalLookup = newPrefix + remoteJndiName.substring(javaAppLength);
            jndiObj = context.lookup(globalLookup);
            resolved = true;
        } else {
            String remoteJndiName = EJBUtils.getRemoteEjbJndiName(ejbRefDesc);
            ClassLoader origClassLoader = Utility.getClassLoader();
            boolean setCL = false;
            try {
                try {
                    String refInterface = ejbRefDesc.isEJB30ClientView() ? ejbRefDesc.getEjbInterface() : ejbRefDesc.getHomeClassName();
                    origClassLoader.loadClass(refInterface);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader referringBundleClassLoader = ejbRefDesc.getReferringBundleDescriptor().getClassLoader();
                    Utility.setContextClassLoader(referringBundleClassLoader);
                    setCL = true;
                }
                if (remoteJndiName.startsWith(CORBANAME)) {
                    GlassFishORBHelper orbHelper = this.glassFishORBHelperProvider.get();
                    ORB orb = orbHelper.getORB();
                    jndiObj = orb.string_to_object(remoteJndiName);
                } else {
                    jndiObj = context.lookup(remoteJndiName);
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Exception resolving Ejb for '" + ejbRefDesc + "' .  Actual (possibly internal) Remote JNDI name used for lookup is '" + remoteJndiName + "'");
                ne.initCause(e);
                throw ne;
            }
            finally {
                if (setCL) {
                    Utility.setContextClassLoader(origClassLoader);
                }
            }
        }
        return resolved ? jndiObj : EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
    }

    @Override
    public boolean isEjbReferenceCacheable(EjbReferenceDescriptor ejbRefDesc) {
        return !ejbRefDesc.isEJB30ClientView() && ejbRefDesc.getEjbDescriptor() != null;
    }

    @Override
    public Object getEJBContextObject(String contextType) {
        Object currentInv = this.invMgr.getCurrentInvocation();
        if (currentInv == null) {
            throw new IllegalStateException("no current invocation");
        }
        if (((ComponentInvocation)currentInv).getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            throw new IllegalStateException("Illegal invocation type for EJB Context : " + (Object)((Object)((ComponentInvocation)currentInv).getInvocationType()));
        }
        EjbInvocation ejbInv = (EjbInvocation)currentInv;
        Object returnObject = ejbInv.context;
        if (contextType.equals("javax.ejb.TimerService")) {
            if (EJBTimerService.getEJBTimerService() == null) {
                throw new IllegalStateException("EJB Timer Service not available");
            }
            returnObject = new EJBTimerServiceWrapper(EJBTimerService.getEJBTimerService(), (EJBContextImpl)ejbInv.context);
        }
        return returnObject;
    }
}

