/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileLister;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileSubstitutionHandler
implements Substitutable {
    protected static final Logger _logger = SLogger.getLogger();
    protected static final LocalStringsImpl _strings = new LocalStringsImpl(FileLister.class);
    protected Reader _reader;
    protected Writer _writer;
    protected File _inputFile;

    public FileSubstitutionHandler(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(_strings.get("invalidFileLocation", file.getAbsolutePath()));
        }
        this._inputFile = file;
    }

    @Override
    public String getName() {
        return this._inputFile.getAbsolutePath();
    }

    @Override
    public void finish() {
        block7: {
            block6: {
                if (this._reader != null) {
                    try {
                        this._reader.close();
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINER)) break block6;
                        _logger.log(Level.FINER, _strings.get("errorInClosingStream", this._inputFile.getAbsolutePath()), e);
                    }
                }
            }
            if (this._writer != null) {
                try {
                    this._writer.close();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINER)) break block7;
                    _logger.log(Level.FINER, _strings.get("errorInClosingStream"), e);
                }
            }
        }
    }
}

