/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.cache.AdminCache;
import com.sun.enterprise.admin.util.cache.AdminCacheUtils;
import com.sun.enterprise.admin.util.cache.DataProvider;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminCacheFileStore
implements AdminCache {
    private static final String DEFAULT_FILENAME = "#default#.cache";
    private static final AdminCacheFileStore instance = new AdminCacheFileStore();
    private static final Logger logger = AdminLoggerInfo.getLogger();
    private AdminCacheUtils adminCahceUtils = AdminCacheUtils.getInstance();

    private AdminCacheFileStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(String key, Class<A> clazz) {
        Object object;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Attribute clazz can not be null.");
        }
        DataProvider provider = this.adminCahceUtils.getProvider(clazz);
        if (provider == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = this.getInputStream(key);
            object = provider.toInstance(is, clazz);
        }
        catch (FileNotFoundException ex) {
            A a = null;
            return a;
        }
        catch (IOException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "NCLS-ADMIN-00016", new Object[]{key});
            }
            A a = null;
            return a;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return (A)object;
    }

    private InputStream getInputStream(String key) throws IOException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCahceUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        File f = this.getCacheFile(key);
        return new BufferedInputStream(new FileInputStream(f));
    }

    private File getCacheFile(String key) throws IOException {
        File dir = AsadminSecurityUtil.getDefaultClientDir();
        int idx = key.lastIndexOf(47);
        if (idx > 0) {
            if (!FileUtils.mkdirsMaybe(dir = new File(dir, key.substring(0, idx)))) {
                throw new IOException("Can't create directory: " + dir);
            }
            if ((key = key.substring(idx + 1)).isEmpty()) {
                key = DEFAULT_FILENAME;
            }
        }
        return new File(dir, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(String key, Object data) {
        File cacheFile;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCahceUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        if (data == null) {
            throw new IllegalArgumentException("Attribute data can not be null.");
        }
        DataProvider provider = this.adminCahceUtils.getProvider(data.getClass());
        if (provider == null) {
            throw new IllegalStateException("There is no data provider for " + data.getClass());
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException ex) {
            return;
        }
        OutputStream os = null;
        try {
            File tempFile = File.createTempFile("temp", "cache", cacheFile.getParentFile());
            os = new BufferedOutputStream(new FileOutputStream(tempFile));
            provider.writeToStream(data, os);
            os.close();
            if (!FileUtils.deleteFileMaybe(cacheFile) || !tempFile.renameTo(cacheFile)) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "NCLS-ADMIN-00017", new Object[]{cacheFile.getPath()});
                }
                if (!FileUtils.deleteFileMaybe(tempFile)) {
                    logger.log(Level.FINE, "can't delete file: {0}", tempFile);
                }
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "NCLS-ADMIN-00017", new Object[]{cacheFile.getPath()});
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean contains(String key) {
        File cacheFile;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCahceUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException ex) {
            return false;
        }
        return cacheFile.exists() && cacheFile.isFile();
    }

    @Override
    public Date lastUpdated(String key) {
        File cacheFile;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCahceUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException ex) {
            return null;
        }
        if (!cacheFile.exists() || !cacheFile.isFile()) {
            return null;
        }
        return new Date(cacheFile.lastModified());
    }

    public static AdminCacheFileStore getInstance() {
        return instance;
    }
}

