/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:app/", "java:app/AppName", "java:module/", "java:module/ModuleName", "java:app/hk2/ServiceLocator"})
public class JavaModuleNamingProxy
implements NamedNamingObjectProxy,
PostConstruct {
    @Inject
    ServiceLocator habitat;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ApplicationRegistry applicationRegistry;
    private ProcessEnvironment.ProcessType processType;
    private static Logger _logger = LogDomains.getLogger(JavaModuleNamingProxy.class, "javax.enterprise.system.core.naming");
    private InitialContext ic;
    static final String JAVA_MODULE_CONTEXT = "java:module/";
    static final String JAVA_APP_CONTEXT = "java:app/";
    static final String JAVA_APP_NAME = "java:app/AppName";
    static final String JAVA_MODULE_NAME = "java:module/ModuleName";
    static final String JAVA_APP_SERVICE_LOCATOR = "java:app/hk2/ServiceLocator";

    @Override
    public void postConstruct() {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("JavaModuleNamingProxy InitialContext creation failure", ne);
        }
        this.processType = this.processEnv.getProcessType();
    }

    @Override
    public Object handle(String name) throws NamingException {
        Object returnValue = null;
        if (name.equals(JAVA_APP_NAME)) {
            returnValue = this.getAppName();
        } else if (name.equals(JAVA_MODULE_NAME)) {
            returnValue = this.getModuleName();
        } else if (name.equals(JAVA_APP_SERVICE_LOCATOR)) {
            returnValue = this.getAppServiceLocator();
        } else if (name.startsWith(JAVA_MODULE_CONTEXT) || name.startsWith(JAVA_APP_CONTEXT)) {
            returnValue = this.getJavaModuleOrAppEJB(name);
        }
        return returnValue;
    }

    private String getAppName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0]);
        String appName = null;
        if (namingMgr != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            BundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)((Object)env);
            }
            if (bd != null) {
                Application app = bd.getApplication();
                appName = app.getAppName();
            } else {
                ApplicationEnvironment applicationEnvironment = namingMgr.getCurrentApplicationEnvironment();
                if (applicationEnvironment != null) {
                    appName = applicationEnvironment.getName();
                }
            }
        }
        if (appName == null) {
            throw new NamingException("Could not resolve java:app/AppName");
        }
        return appName;
    }

    private String getModuleName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0]);
        String moduleName = null;
        if (namingMgr != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            BundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)((Object)env);
            }
            if (bd != null) {
                moduleName = bd.getModuleDescriptor().getModuleName();
            }
        }
        if (moduleName == null) {
            throw new NamingException("Could not resolve java:module/ModuleName");
        }
        return moduleName;
    }

    private ServiceLocator getAppServiceLocator() throws NamingException {
        String appName = this.getAppName();
        ApplicationInfo info = this.applicationRegistry.get(appName);
        if (info == null) {
            throw new NamingException("Could not resolve java:app/hk2/ServiceLocator");
        }
        return info.getAppServiceLocator();
    }

    private Object getJavaModuleOrAppEJB(String name) throws NamingException {
        ComponentEnvManager namingMgr;
        String newName = null;
        Object returnValue = null;
        if (this.habitat != null && (namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0])) != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            BundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)((Object)env);
            }
            if (bd != null) {
                Application app = bd.getApplication();
                String appName = null;
                if (!app.isVirtual()) {
                    appName = app.getAppName();
                }
                String moduleName = bd.getModuleDescriptor().getModuleName();
                StringBuffer javaGlobalName = new StringBuffer("java:global/");
                if (name.startsWith(JAVA_APP_CONTEXT)) {
                    if (appName != null) {
                        javaGlobalName.append(appName);
                        javaGlobalName.append("/");
                    }
                    int javaAppLength = JAVA_APP_CONTEXT.length();
                    javaGlobalName.append(name.substring(javaAppLength));
                } else {
                    if (appName != null) {
                        javaGlobalName.append(appName);
                        javaGlobalName.append("/");
                    }
                    javaGlobalName.append(moduleName);
                    javaGlobalName.append("/");
                    int javaModuleLength = JAVA_MODULE_CONTEXT.length();
                    javaGlobalName.append(name.substring(javaModuleLength));
                }
                newName = javaGlobalName.toString();
            }
        }
        if (newName != null) {
            try {
                if (this.processType == ProcessEnvironment.ProcessType.ACC) {
                    ManagedBeanManager mbMgr = this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
                    try {
                        returnValue = mbMgr.getManagedBean(newName);
                    }
                    catch (Exception e) {
                        NamingException ne = new NamingException("Error creating ACC managed bean " + newName);
                        ne.initCause(e);
                        throw ne;
                    }
                }
                if (returnValue == null) {
                    returnValue = this.ic.lookup(newName);
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, newName + " Unable to map " + name + " to derived name " + newName, ne);
            }
        }
        return returnValue;
    }
}

