/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class AnnotationDetector {
    protected final ClassFile classFile;
    protected final AnnotationScanner scanner;

    public AnnotationDetector(AnnotationScanner scanner) {
        this.scanner = scanner;
        ConstantPoolInfo poolInfo = new ConstantPoolInfo(scanner);
        this.classFile = new ClassFile(poolInfo);
    }

    public boolean hasAnnotationInArchiveWithNoScanning(ReadableArchive archive) throws IOException {
        Types types = null;
        types = archive.getParentArchive() != null ? archive.getParentArchive().getExtraData(Types.class) : archive.getExtraData(Types.class);
        if (types == null) {
            return this.hasAnnotationInArchive(archive);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(archive.getURI());
        try {
            uris.addAll(DOLUtils.getLibraryJarURIs(null, archive));
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, e.getMessage(), e);
        }
        this.scanner.isAnnotation("foo");
        Set<String> annotations = this.scanner.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (String annotationType : annotations) {
            Type type2 = types.getBy(annotationType);
            if (type2 == null || !(type2 instanceof AnnotationType)) continue;
            Collection<AnnotatedElement> elements = ((AnnotationType)type2).allAnnotatedTypes();
            for (AnnotatedElement element : elements) {
                ExtensibleType<?> t = element instanceof Member ? ((Member)((Object)element)).getDeclaringType() : (ExtensibleType<?>)element;
                if (!t.wasDefinedIn(uris)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnnotationInArchive(ReadableArchive archive) throws IOException {
        Enumeration<String> entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement();
            if (!entryName.endsWith(".class") || !this.containsAnnotation(archive, entryName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnnotation(ReadableArchive archive, String entryName) throws IOException {
        return this.containsAnnotation(archive.getEntry(entryName), archive.getEntrySize(entryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAnnotation(InputStream is, long size) throws IOException {
        boolean result = false;
        try (ReadableByteChannel channel = null;){
            channel = Channels.newChannel(is);
            if (channel != null) {
                result = this.classFile.containsAnnotation(channel, size);
            }
            boolean bl = result;
            return bl;
        }
    }
}

