/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class SystemResourceManagerImpl
implements ResourceManager {
    private static Logger _logger = LogDomains.getLogger(SystemResourceManagerImpl.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public Transaction getTransaction() throws PoolingException {
        try {
            return ConnectorRuntime.getRuntime().getTransaction();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    @Override
    public Object getComponent() {
        return null;
    }

    @Override
    public void enlistResource(ResourceHandle handle) throws PoolingException {
        try {
            JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
            Transaction tran = tm.getTransaction();
            if (tran != null) {
                tm.enlistResource(tran, handle);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    @Override
    public void registerResource(ResourceHandle handle) throws PoolingException {
    }

    @Override
    public void rollBackTransaction() {
        try {
            JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
            Transaction tran = tm.getTransaction();
            if (tran != null) {
                tran.setRollbackOnly();
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void delistResource(ResourceHandle h, int xaresFlag) {
        try {
            JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
            Transaction tran = tm.getTransaction();
            if (tran != null) {
                tm.delistResource(tran, h, xaresFlag);
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
    }
}

