/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.RoleMapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RoleMapperFactory
implements SecurityRoleMapperFactory {
    private Map CONTEXT_TO_APPNAME = new HashMap();
    private Hashtable ROLEMAPPER = new Hashtable();

    @Override
    public SecurityRoleMapper getRoleMapper(String appName) {
        String contextId = appName;
        String appname = this.getAppNameForContext(appName);
        RoleMapper srm = null;
        if (appname != null) {
            srm = this.getRoleMapper(appname, this);
        }
        if (srm == null) {
            srm = this.getRoleMapper(contextId, this);
        }
        return srm;
    }

    @Override
    public String getAppNameForContext(String contextId) {
        return (String)this.CONTEXT_TO_APPNAME.get(contextId);
    }

    @Override
    public void setAppNameForContext(String appName, String contextId) {
        this.CONTEXT_TO_APPNAME.put(contextId, appName);
    }

    @Override
    public void removeAppNameForContext(String contextId) {
        this.CONTEXT_TO_APPNAME.remove(contextId);
    }

    public RoleMapper getRoleMapper(String appName, SecurityRoleMapperFactory fact) {
        RoleMapper r = (RoleMapper)this.ROLEMAPPER.get(appName);
        if (r == null) {
            r = new RoleMapper(appName);
            this.ROLEMAPPER.put(appName, r);
        }
        return r;
    }

    @Override
    public void setRoleMapper(String appName, SecurityRoleMapper rmap) {
        this.ROLEMAPPER.put(appName, rmap);
    }

    @Override
    public void removeRoleMapper(String appName) {
        if (this.ROLEMAPPER.containsKey(appName)) {
            this.ROLEMAPPER.remove(appName);
        }
    }
}

