/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.digest.impl;

import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.api.NestedDigestAlgoParam;
import com.sun.enterprise.security.auth.digest.api.Password;
import com.sun.enterprise.security.auth.digest.impl.KeyDigestAlgoParamImpl;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DigestProcessor {
    private Password passwd;
    private Logger _logger = LogDomains.getLogger(DigestProcessor.class, "javax.enterprise.system.core.security");
    private static final StringManager sm = StringManager.getManager(DigestProcessor.class);
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final MD5Encoder md5Encoder = new MD5Encoder();

    public String createDigest(Password passwd2, DigestAlgorithmParameter[] params) throws NoSuchAlgorithmException {
        try {
            DigestAlgorithmParameter data = null;
            Object clientResponse = null;
            DigestAlgorithmParameter key = null;
            this.passwd = passwd2;
            for (int i = 0; i < params.length; ++i) {
                DigestAlgorithmParameter dap = params[i];
                if ("A1".equals(dap.getName()) && dap instanceof Key) {
                    key = dap;
                    continue;
                }
                data = dap;
            }
            byte[] p1 = this.valueOf(key);
            byte[] p2 = this.valueOf(data);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(p1);
            bos.write(":".getBytes());
            bos.write(p2);
            MessageDigest md = MessageDigest.getInstance(key.getAlgorithm());
            Object derivedKey = null;
            byte[] dk = md.digest(bos.toByteArray());
            String tmp = this.getMd5Encoder().encode(dk);
            return tmp;
        }
        catch (IOException ex) {
            Object[] parm = new String[1];
            parm[1] = ex.getMessage();
            this._logger.log(Level.SEVERE, "create.digest.error", parm);
            this._logger.log(Level.FINE, "", ex);
            return null;
        }
    }

    protected abstract boolean validate(Password var1, DigestAlgorithmParameter[] var2) throws NoSuchAlgorithmException;

    protected final byte[] valueOf(DigestAlgorithmParameter param) throws NoSuchAlgorithmException {
        if (param instanceof KeyDigestAlgoParamImpl) {
            return this.valueOf((KeyDigestAlgoParamImpl)param);
        }
        if (param instanceof NestedDigestAlgoParam) {
            return this.valueOf((NestedDigestAlgoParam)param);
        }
        if (param.getAlgorithm() == null || param.getAlgorithm().length() == 0) {
            return param.getValue();
        }
        MessageDigest md = MessageDigest.getInstance(param.getAlgorithm());
        md.update(param.getValue());
        byte[] dk = md.digest();
        String tmp = this.getMd5Encoder().encode(dk);
        return tmp.getBytes();
    }

    protected void setPassword(Password passwd2) {
        this.passwd = passwd2;
    }

    private byte[] valueOf(KeyDigestAlgoParamImpl param) throws NoSuchAlgorithmException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.passwd.getType() == 0) {
            try {
                bos.write(param.getUsername().getBytes());
                bos.write(param.getDelimiter());
                bos.write(param.getRealmName().getBytes());
                bos.write(param.getDelimiter());
                bos.write(this.passwd.getValue());
                MessageDigest md = MessageDigest.getInstance(param.getAlgorithm());
                byte[] dk = md.digest(bos.toByteArray());
                String tmp = this.getMd5Encoder().encode(dk);
                return tmp.getBytes();
            }
            catch (IOException ex) {
                this._logger.log(Level.SEVERE, "digest.param.error", ex);
            }
        } else {
            return this.passwd.getValue();
        }
        return null;
    }

    private byte[] valueOf(NestedDigestAlgoParam param) throws NoSuchAlgorithmException {
        ByteArrayOutputStream bos = null;
        AlgorithmParameterSpec[] datastore = param.getNestedParams();
        bos = new ByteArrayOutputStream();
        for (int i = 0; i < datastore.length; ++i) {
            DigestAlgorithmParameter dataP = (DigestAlgorithmParameter)datastore[i];
            byte[] tmpData = this.valueOf(dataP);
            bos.write(tmpData, 0, tmpData.length);
            if (param.getDelimiter() == null || i + 1 >= datastore.length) continue;
            bos.write(param.getDelimiter(), 0, param.getDelimiter().length);
        }
        if (this.hasAlgorithm(param)) {
            MessageDigest md = MessageDigest.getInstance(param.getAlgorithm());
            byte[] dk = md.digest(bos.toByteArray());
            String tmp = this.getMd5Encoder().encode(dk);
            return tmp.getBytes();
        }
        return bos.toByteArray();
    }

    public MD5Encoder getMd5Encoder() {
        return this.md5Encoder;
    }

    public String encode(byte[] dk) {
        return this.getMd5Encoder().encode(dk);
    }

    private boolean hasAlgorithm(DigestAlgorithmParameter param) {
        return param.getAlgorithm() != null && param.getAlgorithm().length() != 0;
    }

    static class MD5Encoder {
        MD5Encoder() {
        }

        public String encode(byte[] binaryData) {
            if (binaryData.length != 16) {
                return null;
            }
            char[] buffer = new char[32];
            for (int i = 0; i < 16; ++i) {
                int low = binaryData[i] & 0xF;
                int high = (binaryData[i] & 0xF0) >> 4;
                buffer[i * 2] = hexadecimal[high];
                buffer[i * 2 + 1] = hexadecimal[low];
            }
            return new String(buffer);
        }
    }
}

