/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-message-security-provider")
@PerLookup
@I18n(value="delete.message.security.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteMessageSecurityProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteMessageSecurityProvider.class);
    @Param(name="providername", primary=true)
    String providerId;
    @Param(name="layer", defaultValue="SOAP")
    String authLayer;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    ProviderConfig thePC = null;
    @AccessRequired.To(value={"delete"})
    private MessageSecurityConfig msgSecCfg = null;
    private SecurityService secService;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.secService = this.config.getSecurityService();
        this.msgSecCfg = CLIUtil.findMessageSecurityConfig(this.secService, this.authLayer);
        if (this.msgSecCfg == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("delete.message.security.provider.confignotfound", "A Message security config does not exist for the layer {0}", this.authLayer));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List<ProviderConfig> pcs = this.msgSecCfg.getProviderConfig();
        for (ProviderConfig pc : pcs) {
            if (!pc.getProviderId().equals(this.providerId)) continue;
            this.thePC = pc;
            try {
                ConfigSupport.apply(new SingleConfigCode<MessageSecurityConfig>(){

                    @Override
                    public Object run(MessageSecurityConfig param) throws PropertyVetoException, TransactionFailure {
                        if (param.getDefaultProvider() != null && param.getDefaultProvider().equals(DeleteMessageSecurityProvider.this.thePC.getProviderId())) {
                            param.setDefaultProvider(null);
                        }
                        if (param.getDefaultClientProvider() != null && param.getDefaultClientProvider().equals(DeleteMessageSecurityProvider.this.thePC.getProviderId())) {
                            param.setDefaultClientProvider(null);
                        }
                        param.getProviderConfig().remove(DeleteMessageSecurityProvider.this.thePC);
                        return null;
                    }
                }, this.msgSecCfg);
            }
            catch (TransactionFailure e) {
                e.printStackTrace();
                report.setMessage(localStrings.getLocalString("delete.message.security.provider.fail", "Deletion of message security provider named {0} failed", this.providerId));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
    }
}

