/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="AdminConsoleStartupService")
@RunLevel(value=20)
public class AdminConsoleStartupService
implements PostConstruct {
    @Inject
    private AdminService adminService;
    @Inject
    @Optional
    private AdminConsoleAdapter adminConsoleAdapter = null;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject
    private Domain domain;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private final long ONE_DAY = 86400000L;

    @Override
    public void postConstruct() {
        if (this.adminConsoleAdapter == null) {
            return;
        }
        if (!this.env.isDas()) {
            return;
        }
        Property initProp = this.adminService.getProperty("adminConsoleStartup");
        String initPropVal = "DEFAULT";
        if (!(initProp == null || (initPropVal = initProp.getValue()).equals("ALWAYS") || initPropVal.equals("NEVER") || initPropVal.equals("DEFAULT"))) {
            initPropVal = "DEFAULT";
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AdminConsoleStartupService, console loading option is {0}", initPropVal);
        }
        if (initPropVal.equalsIgnoreCase("DEFAULT")) {
            this.handleDefault();
        } else if (initPropVal.equalsIgnoreCase("ALWAYS")) {
            this.handleHigh();
        }
    }

    private void handleDefault() {
        if (this.domain.getServers().getServer().size() > 1) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "AdminConsoleStartup DAS usecase");
            }
            this.handleHigh();
            return;
        }
        long currentTime = System.currentTimeMillis();
        try {
            long lastTime = this.getTimeStamp();
            if (currentTime - lastTime < 86400000L) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "AdminConsoleStartup frequent user, lastTime =  ", lastTime);
                }
                this.handleHigh();
            }
        }
        catch (IOException ex) {
            logger.fine(ex.getMessage());
        }
    }

    private void handleLow() {
        this.adminConsoleAdapter.initRest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHigh() {
        this.handleLow();
        AdminConsoleStartupService adminConsoleStartupService = this;
        synchronized (adminConsoleStartupService) {
            if (!this.adminConsoleAdapter.isInstalling() && !this.adminConsoleAdapter.isApplicationLoaded()) {
                this.adminConsoleAdapter.loadConsole();
            }
        }
    }

    private long getTimeStamp() throws IOException {
        File f = new File(this.env.getConfigDirPath(), ".consolestate");
        if (!f.exists()) {
            return 0L;
        }
        return f.lastModified();
    }
}

