/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Transport;

public class ConnectionMonitor
implements ConnectionProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public ConnectionMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, Transport transport) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
    }

    @Override
    public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
        Object peerAddress = clientConnection.getPeerAddress();
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionAcceptedEvent(this.monitoringId, clientConnection.hashCode(), peerAddress.toString());
    }

    @Override
    public void onConnectEvent(Connection connection) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionConnectedEvent(this.monitoringId, connection.hashCode(), connection.getPeerAddress().toString());
    }

    @Override
    public void onCloseEvent(Connection connection) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionClosedEvent(this.monitoringId, connection.hashCode());
    }

    @Override
    public void onBindEvent(Connection connection) {
    }

    @Override
    public void onReadEvent(Connection connection, Buffer data, int size) {
    }

    @Override
    public void onWriteEvent(Connection connection, Buffer data, long size) {
    }

    @Override
    public void onErrorEvent(Connection connection, Throwable error) {
    }

    @Override
    public void onIOEventReadyEvent(Connection connection, IOEvent ioEvent) {
    }

    @Override
    public void onIOEventEnableEvent(Connection connection, IOEvent ioEvent) {
    }

    @Override
    public void onIOEventDisableEvent(Connection connection, IOEvent ioEvent) {
    }
}

