/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.DelegatingAnnotationProvider;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.DocumentOrderingWrapper;
import com.sun.faces.config.FacesConfigInfo;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.MetaInfFaceletTaglibraryConfigProvider;
import com.sun.faces.config.configprovider.MetaInfFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.MojarraFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.WebAppFlowConfigResourceProvider;
import com.sun.faces.config.configprovider.WebFaceletTaglibResourceProvider;
import com.sun.faces.config.configprovider.WebFacesConfigResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.BehaviorConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FaceletTaglibConfigProcessor;
import com.sun.faces.config.processor.FacesConfigExtensionProcessor;
import com.sun.faces.config.processor.FacesFlowDefinitionConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.ProtectedViewsConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ResourceLibraryContractsConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.AnnotationProviderFactory;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.ConfigurationResourceProviderFactory;
import com.sun.faces.spi.HighAvailabilityEnabler;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationConfigurationPopulator;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private final List<ConfigurationResourceProvider> FACES_CONFIG_RESOURCE_PROVIDERS;
    private final List<ConfigurationResourceProvider> FACELET_TAGLIBRARY_RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final String CONFIG_MANAGER_INSTANCE_KEY = "com.sun.faces.CONFIG_MANAGER_KEY";
    private static final String ANNOTATIONS_SCAN_TASK_KEY = ConfigManager.class.getName() + "_ANNOTATION_SCAN_TASK";
    public static final String INJECTION_PROVIDER_KEY = ConfigManager.class.getName() + "_INJECTION_PROVIDER_TASK";
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private final ConfigProcessor FACES_CONFIG_PROCESSOR_CHAIN;
    private final ConfigProcessor FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN;
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";

    public ConfigManager() {
        ArrayList<ConfigurationResourceProvider> facesConfigProviders = new ArrayList<ConfigurationResourceProvider>(3);
        facesConfigProviders.add(new MojarraFacesConfigResourceProvider());
        facesConfigProviders.add(new MetaInfFacesConfigResourceProvider());
        facesConfigProviders.add(new WebAppFlowConfigResourceProvider());
        facesConfigProviders.add(new WebFacesConfigResourceProvider());
        this.FACES_CONFIG_RESOURCE_PROVIDERS = Collections.unmodifiableList(facesConfigProviders);
        ArrayList<ConfigurationResourceProvider> faceletTaglibProviders = new ArrayList<ConfigurationResourceProvider>(3);
        faceletTaglibProviders.add(new MetaInfFaceletTaglibraryConfigProvider());
        faceletTaglibProviders.add(new WebFaceletTaglibResourceProvider());
        this.FACELET_TAGLIBRARY_RESOURCE_PROVIDERS = Collections.unmodifiableList(faceletTaglibProviders);
        ConfigProcessor[] configProcessors = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor(), new BehaviorConfigProcessor(), new FacesConfigExtensionProcessor(), new ProtectedViewsConfigProcessor(), new FacesFlowDefinitionConfigProcessor(), new ResourceLibraryContractsConfigProcessor()};
        for (int i = 0; i < configProcessors.length; ++i) {
            ConfigProcessor p = configProcessors[i];
            if (i + 1 >= configProcessors.length) continue;
            p.setNext(configProcessors[i + 1]);
        }
        this.FACES_CONFIG_PROCESSOR_CHAIN = configProcessors[0];
        this.FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN = new FaceletTaglibConfigProcessor();
    }

    public static ConfigManager getInstance(ServletContext sc) {
        return (ConfigManager)sc.getAttribute(CONFIG_MANAGER_INSTANCE_KEY);
    }

    public static ConfigManager createInstance(ServletContext sc) {
        ConfigManager result = new ConfigManager();
        sc.setAttribute(CONFIG_MANAGER_INSTANCE_KEY, result);
        return result;
    }

    public static void removeInstance(ServletContext sc) {
        sc.removeAttribute(CONFIG_MANAGER_INSTANCE_KEY);
    }

    private void initializeConfigProcessers(ServletContext sc) {
        ConfigProcessor p = this.FACES_CONFIG_PROCESSOR_CHAIN;
        do {
            p.initializeClassMetadataMap(sc);
        } while (null != (p = p.getNext()));
    }

    public void initialize(ServletContext sc) {
        if (!this.hasBeenInitialized(sc)) {
            this.initializedContexts.add(sc);
            this.initializeConfigProcessers(sc);
            ExecutorService executor = null;
            try {
                WebConfiguration webConfig = WebConfiguration.getInstance(sc);
                boolean validating = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
                if (ConfigManager.useThreads(sc)) {
                    executor = ConfigManager.createExecutorService();
                }
                DocumentInfo[] facesDocuments = ConfigManager.getConfigDocuments(sc, this.getFacesConfigResourceProviders(), executor, validating);
                FacesConfigInfo lastFacesConfigInfo = new FacesConfigInfo(facesDocuments[facesDocuments.length - 1]);
                facesDocuments = this.sortDocuments(facesDocuments, lastFacesConfigInfo);
                InitFacesContext context = (InitFacesContext)FacesContext.getCurrentInstance();
                InjectionProvider containerConnector = InjectionProviderFactory.createInstance(context.getExternalContext());
                context.getAttributes().put(INJECTION_PROVIDER_KEY, containerConnector);
                boolean isFaceletsDisabled = false;
                if (lastFacesConfigInfo.isWebInfFacesConfig()) {
                    isFaceletsDisabled = this.isFaceletsDisabled(webConfig, lastFacesConfigInfo);
                }
                if (!lastFacesConfigInfo.isWebInfFacesConfig() || !lastFacesConfigInfo.isMetadataComplete()) {
                    Future<Map<Class<? extends Annotation>, Set<Class<?>>>> annotationScan;
                    ProvideMetadataToAnnotationScanTask taskMetadata = new ProvideMetadataToAnnotationScanTask(facesDocuments, containerConnector);
                    if (executor != null) {
                        annotationScan = executor.submit(new AnnotationScanTask(sc, context, taskMetadata));
                        this.pushTaskToContext(sc, annotationScan);
                    } else {
                        annotationScan = new FutureTask(new AnnotationScanTask(sc, context, taskMetadata));
                        ((FutureTask)annotationScan).run();
                    }
                    this.pushTaskToContext(sc, annotationScan);
                }
                if (containerConnector instanceof HighAvailabilityEnabler) {
                    ((HighAvailabilityEnabler)((Object)containerConnector)).enableHighAvailability(sc);
                }
                ServiceLoader<ApplicationConfigurationPopulator> populators = ServiceLoader.load(ApplicationConfigurationPopulator.class);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                DOMImplementation domImpl = builder.getDOMImplementation();
                ArrayList<DocumentInfo> programmaticDocuments = new ArrayList<DocumentInfo>();
                for (ApplicationConfigurationPopulator pop : populators) {
                    Document newDoc = domImpl.createDocument("http://xmlns.jcp.org/xml/ns/javaee", "faces-config", null);
                    Attr versionAttribute = newDoc.createAttribute("version");
                    versionAttribute.setValue("2.2");
                    newDoc.getDocumentElement().getAttributes().setNamedItem(versionAttribute);
                    try {
                        pop.populateApplicationConfiguration(newDoc);
                        DocumentInfo newDocInfo = new DocumentInfo(newDoc, null);
                        programmaticDocuments.add(newDocInfo);
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, "{0} thrown when invoking {1}.populateApplicationConfigurationResources: {2}", new String[]{e.getClass().getName(), pop.getClass().getName(), e.getMessage()});
                    }
                }
                if (!programmaticDocuments.isEmpty()) {
                    DocumentInfo[] newDocumentInfo = new DocumentInfo[facesDocuments.length + programmaticDocuments.size()];
                    System.arraycopy(facesDocuments, 0, newDocumentInfo, 0, facesDocuments.length);
                    int i = facesDocuments.length;
                    Iterator i$ = programmaticDocuments.iterator();
                    while (i$.hasNext()) {
                        DocumentInfo cur;
                        newDocumentInfo[i] = cur = (DocumentInfo)i$.next();
                    }
                    facesDocuments = newDocumentInfo;
                }
                this.FACES_CONFIG_PROCESSOR_CHAIN.process(sc, facesDocuments);
                if (!isFaceletsDisabled) {
                    this.FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN.process(sc, ConfigManager.getConfigDocuments(sc, this.getFaceletConfigResourceProviders(), executor, validating));
                }
            }
            catch (Exception e) {
                this.releaseFactories();
                Exception t = e;
                if (!(e instanceof ConfigurationException)) {
                    t = new ConfigurationException("CONFIGURATION FAILED! " + t.getMessage(), t);
                }
                throw (ConfigurationException)t;
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
                sc.removeAttribute(ANNOTATIONS_SCAN_TASK_KEY);
            }
        }
        DbfFactory.removeSchemaMap(sc);
    }

    public void destroy(ServletContext sc) {
        this.FACES_CONFIG_PROCESSOR_CHAIN.destroy(sc);
        this.initializedContexts.remove(sc);
    }

    public boolean hasBeenInitialized(ServletContext sc) {
        return this.initializedContexts.contains(sc);
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(FacesContext ctx) {
        Map<String, Object> appMap = ctx.getExternalContext().getApplicationMap();
        Future scanTask = (Future)appMap.get(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return scanTask != null ? (Map)scanTask.get() : Collections.emptyMap();
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
    }

    private static boolean useThreads(ServletContext ctx) {
        WebConfiguration config = WebConfiguration.getInstance(ctx);
        return config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private List<ConfigurationResourceProvider> getFacesConfigResourceProviders() {
        return this.getConfigurationResourceProviders(this.FACES_CONFIG_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FacesConfig);
    }

    private List<ConfigurationResourceProvider> getFaceletConfigResourceProviders() {
        return this.getConfigurationResourceProviders(this.FACELET_TAGLIBRARY_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FaceletConfig);
    }

    private List<ConfigurationResourceProvider> getConfigurationResourceProviders(List<ConfigurationResourceProvider> defaultProviders, ConfigurationResourceProviderFactory.ProviderType providerType) {
        ConfigurationResourceProvider[] custom = ConfigurationResourceProviderFactory.createProviders(providerType);
        if (custom.length == 0) {
            return defaultProviders;
        }
        ArrayList<ConfigurationResourceProvider> list = new ArrayList<ConfigurationResourceProvider>();
        list.addAll(defaultProviders);
        list.addAll(defaultProviders.size() - 1, Arrays.asList(custom));
        return Collections.unmodifiableList(list);
    }

    private DocumentInfo[] sortDocuments(DocumentInfo[] facesDocuments, FacesConfigInfo webInfFacesConfig) {
        int len = webInfFacesConfig.isWebInfFacesConfig() ? facesDocuments.length - 1 : facesDocuments.length;
        List<String> absoluteOrdering = webInfFacesConfig.getAbsoluteOrdering();
        if (len > 1) {
            ArrayList<DocumentOrderingWrapper> list = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < len; ++i) {
                list.add(new DocumentOrderingWrapper(facesDocuments[i]));
            }
            DocumentOrderingWrapper[] ordering = list.toArray(new DocumentOrderingWrapper[list.size()]);
            if (absoluteOrdering == null) {
                DocumentOrderingWrapper.sort(ordering);
                for (int i = 1; i < len; ++i) {
                    facesDocuments[i] = ordering[i - 1].getDocument();
                }
                return facesDocuments;
            }
            DocumentOrderingWrapper[] result = DocumentOrderingWrapper.sort(ordering, absoluteOrdering);
            DocumentInfo[] ret = new DocumentInfo[webInfFacesConfig.isWebInfFacesConfig() ? result.length + 2 : result.length + 1];
            for (int i = 1; i < len; ++i) {
                ret[i] = result[i - 1].getDocument();
            }
            ret[0] = facesDocuments[0];
            if (webInfFacesConfig.isWebInfFacesConfig()) {
                ret[ret.length - 1] = facesDocuments[facesDocuments.length - 1];
            }
            return ret;
        }
        return facesDocuments;
    }

    private boolean isFaceletsDisabled(WebConfiguration webconfig, FacesConfigInfo facesConfigInfo) {
        boolean isFaceletsDisabled = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (!isFaceletsDisabled) {
            isFaceletsDisabled = !facesConfigInfo.isVersionGreaterOrEqual(2.0);
            webconfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, isFaceletsDisabled);
        }
        return isFaceletsDisabled;
    }

    private void pushTaskToContext(ServletContext sc, Future<Map<Class<? extends Annotation>, Set<Class<?>>>> scanTask) {
        sc.setAttribute(ANNOTATIONS_SCAN_TASK_KEY, scanTask);
    }

    void publishPostConfigEvent() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        if (null == ((InitFacesContext)ctx).getELContext()) {
            ELContextListener[] listeners;
            UIViewRoot root;
            ELContextImpl elContext = new ELContextImpl(app.getELResolver());
            elContext.putContext(FacesContext.class, ctx);
            ExpressionFactory exFactory = ELUtils.getDefaultExpressionFactory(ctx);
            if (null != exFactory) {
                elContext.putContext(ExpressionFactory.class, exFactory);
            }
            if (null != (root = ctx.getViewRoot())) {
                elContext.setLocale(root.getLocale());
            }
            if ((listeners = app.getELContextListeners()).length > 0) {
                ELContextEvent event = new ELContextEvent(elContext);
                for (ELContextListener listener : listeners) {
                    listener.contextCreated(event);
                }
            }
            ((InitFacesContext)ctx).setELContext(elContext);
        }
        app.publishEvent(ctx, PostConstructApplicationEvent.class, Application.class, app);
    }

    private static DocumentInfo[] getConfigDocuments(ServletContext sc, List<ConfigurationResourceProvider> providers, ExecutorService executor, boolean validating) {
        ArrayList<FutureTask> urlTasks = new ArrayList<FutureTask>(providers.size());
        for (ConfigurationResourceProvider p : providers) {
            FutureTask t = new FutureTask(new URITask(p, sc));
            urlTasks.add(t);
            if (executor != null) {
                executor.execute(t);
                continue;
            }
            t.run();
        }
        ArrayList<FutureTask<DocumentInfo>> docTasks = new ArrayList<FutureTask<DocumentInfo>>(providers.size() << 1);
        for (FutureTask t : urlTasks) {
            try {
                Collection collection = (Collection)t.get();
                for (URI u : collection) {
                    FutureTask<DocumentInfo> d = new FutureTask<DocumentInfo>(new ParseTask(sc, validating, u));
                    docTasks.add(d);
                    if (executor != null) {
                        executor.execute(d);
                        continue;
                    }
                    d.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList docs = new ArrayList(docTasks.size());
        for (FutureTask futureTask : docTasks) {
            try {
                docs.add(futureTask.get());
            }
            catch (ExecutionException e) {
                throw new ConfigurationException(e);
            }
            catch (InterruptedException ignored) {
            }
        }
        return docs.toArray(new DocumentInfo[docs.size()]);
    }

    private static ExecutorService createExecutorService() {
        int tc = Runtime.getRuntime().availableProcessors();
        if (tc > 5) {
            tc = 5;
        }
        return Executors.newFixedThreadPool(tc);
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException ignored) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", ignored);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URITask
    implements Callable<Collection<URI>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URITask(ConfigurationResourceProvider provider, ServletContext sc) {
            this.provider = provider;
            this.sc = sc;
        }

        @Override
        public Collection<URI> call() throws Exception {
            Collection<URI> untypedCollection = this.provider.getResources(this.sc);
            Iterator<URI> untypedCollectionIterator = untypedCollection.iterator();
            Collection<URI> result = Collections.emptyList();
            if (untypedCollectionIterator.hasNext()) {
                URI cur = untypedCollectionIterator.next();
                if (cur instanceof URL) {
                    result = new ArrayList<URI>(untypedCollection.size());
                    result.add(new URI(((URL)((Object)cur)).toExternalForm()));
                    while (untypedCollectionIterator.hasNext()) {
                        cur = untypedCollectionIterator.next();
                        result.add(new URI(((URL)((Object)cur)).toExternalForm()));
                    }
                } else {
                    result = untypedCollection;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<DocumentInfo> {
        private static final String JAVAEE_SCHEMA_LEGACY_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://xmlns.jcp.org/xml/ns/javaee";
        private static final String EMPTY_FACES_CONFIG = "com/sun/faces/empty-faces-config.xml";
        private static final String FACES_CONFIG_TAGNAME = "faces-config";
        private static final String FACELET_TAGLIB_TAGNAME = "facelet-taglib";
        private ServletContext servletContext;
        private URI documentURI;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(ServletContext servletContext, boolean validating, URI documentURI) throws Exception {
            this.servletContext = servletContext;
            this.documentURI = documentURI;
            this.validating = validating;
        }

        @Override
        public DocumentInfo call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document d = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURI.toURL().toExternalForm());
                }
                return new DocumentInfo(d, this.documentURI);
            }
            catch (Exception e) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURI.toURL().toExternalForm(), e.getMessage()), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Document getDocument() throws Exception {
            Document returnDoc;
            Document doc;
            InputSource is;
            URL documentURL;
            DocumentBuilder db;
            block24: {
                db = this.getNonValidatingBuilder();
                documentURL = this.documentURI.toURL();
                is = new InputSource(ParseTask.getInputStream(documentURL));
                is.setSystemId(this.documentURI.toURL().toExternalForm());
                doc = null;
                try {
                    doc = db.parse(is);
                }
                catch (SAXParseException spe) {
                    InputStream stream = is.getByteStream();
                    stream.close();
                    is = new InputSource(ParseTask.getInputStream(documentURL));
                    stream = is.getByteStream();
                    if (!this.streamIsZeroLengthOrEmpty(stream) || !documentURL.toExternalForm().endsWith("faces-config.xml")) break block24;
                    ClassLoader loader = this.getClass().getClassLoader();
                    is = new InputSource(ParseTask.getInputStream(loader.getResource(EMPTY_FACES_CONFIG)));
                    doc = db.parse(is);
                }
            }
            String documentNS = null;
            if (null == doc) {
                if (FacesFlowDefinitionConfigProcessor.uriIsFlowDefinition(this.documentURI)) {
                    documentNS = JAVAEE_SCHEMA_DEFAULT_NS;
                    doc = FacesFlowDefinitionConfigProcessor.synthesizeEmptyFlowDefinition(this.documentURI);
                }
            } else {
                boolean isNonFacesConfigDocument;
                Element documentElement = doc.getDocumentElement();
                documentNS = documentElement.getNamespaceURI();
                String rootElementTagName = documentElement.getTagName();
                boolean bl = isNonFacesConfigDocument = !FACES_CONFIG_TAGNAME.equals(rootElementTagName) && !FACELET_TAGLIB_TAGNAME.equals(rootElementTagName);
                if (isNonFacesConfigDocument) {
                    ClassLoader loader = this.getClass().getClassLoader();
                    is = new InputSource(ParseTask.getInputStream(loader.getResource(EMPTY_FACES_CONFIG)));
                    doc = db.parse(is);
                    if (!LOGGER.isLoggable(Level.WARNING)) return doc;
                    LOGGER.log(Level.WARNING, MessageFormat.format("Config document {0} with namespace URI {1} is not a faces-config or facelet-taglib file.  Ignoring.", this.documentURI.toURL().toExternalForm(), documentNS));
                    return doc;
                }
            }
            if (this.validating && documentNS != null) {
                DOMSource domSource = new DOMSource(doc, documentURL.toExternalForm());
                Element documentElement = ((Document)domSource.getNode()).getDocumentElement();
                if (JAVAEE_SCHEMA_DEFAULT_NS.equals(documentNS)) {
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version == null) throw new ConfigurationException("No document version available.");
                    String versionStr = version.getValue();
                    if (!"2.2".equals(versionStr)) throw new ConfigurationException("Unknown Schema version: " + versionStr);
                    Schema schema = FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_22) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_22);
                    DocumentBuilder builder = this.getBuilderForSchema(schema);
                    if (builder.isValidating()) {
                        builder.getSchema().newValidator().validate(domSource);
                        returnDoc = (Document)domSource.getNode();
                    } else {
                        returnDoc = (Document)domSource.getNode();
                    }
                } else if (JAVAEE_SCHEMA_LEGACY_DEFAULT_NS.equals(documentNS)) {
                    Schema schema;
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version == null) throw new ConfigurationException("No document version available.");
                    String versionStr = version.getValue();
                    if ("2.0".equals(versionStr)) {
                        schema = FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_20);
                    } else if ("2.1".equals(versionStr)) {
                        schema = FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_21);
                    } else {
                        if (!"1.2".equals(versionStr)) throw new ConfigurationException("Unknown Schema version: " + versionStr);
                        schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_12);
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schema);
                    if (builder.isValidating()) {
                        builder.getSchema().newValidator().validate(domSource);
                        returnDoc = (Document)domSource.getNode();
                    } else {
                        returnDoc = (Document)domSource.getNode();
                    }
                } else {
                    Schema schemaToApply;
                    DOMResult domResult = new DOMResult();
                    Transformer transformer = ParseTask.getTransformer(documentNS);
                    transformer.transform(domSource, domResult);
                    ((Document)domResult.getNode()).setDocumentURI(((Document)domSource.getNode()).getDocumentURI());
                    if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(documentNS)) {
                        schemaToApply = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_11);
                    } else {
                        if (!ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(documentNS)) throw new IllegalStateException();
                        schemaToApply = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20);
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schemaToApply);
                    if (builder.isValidating()) {
                        builder.getSchema().newValidator().validate(new DOMSource(domResult.getNode()));
                        returnDoc = (Document)domResult.getNode();
                    } else {
                        returnDoc = (Document)domResult.getNode();
                    }
                }
            } else {
                returnDoc = doc;
            }
            if (!documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) return returnDoc;
            Attr webInf = returnDoc.createAttribute(ConfigManager.WEB_INF_MARKER);
            webInf.setValue("true");
            returnDoc.getDocumentElement().getAttributes().setNamedItem(webInf);
            return returnDoc;
        }

        private boolean streamIsZeroLengthOrEmpty(InputStream is) throws IOException {
            boolean isZeroLengthOrEmpty = 0 == is.available();
            int size = 1024;
            byte[] b = new byte[1024];
            while (!isZeroLengthOrEmpty && -1 != is.read(b, 0, 1024)) {
                String s = new String(b, "UTF-8").trim();
                isZeroLengthOrEmpty = 0 == s.length();
                b[0] = 0;
                for (int i = 1; i < 1024; i += i) {
                    System.arraycopy(b, 0, b, i, 1024 - i < i ? 1024 - i : i);
                }
            }
            return isZeroLengthOrEmpty;
        }

        private static Transformer getTransformer(String documentNS) throws Exception {
            String xslToApply;
            TransformerFactory factory = Util.createTransformerFactory();
            if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(documentNS)) {
                xslToApply = ConfigManager.FACES_TO_1_1_PRIVATE_XSL;
            } else if (ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(documentNS)) {
                xslToApply = ConfigManager.FACELETS_TO_2_0_XSL;
            } else {
                throw new IllegalStateException();
            }
            return factory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(xslToApply))));
        }

        private static InputStream getInputStream(URL url) throws IOException {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return new BufferedInputStream(conn.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory tFactory = DbfFactory.getFactory();
            tFactory.setValidating(false);
            DocumentBuilder tBuilder = tFactory.newDocumentBuilder();
            tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return tBuilder;
        }

        private DocumentBuilder getBuilderForSchema(Schema schema) throws Exception {
            this.factory = DbfFactory.getFactory();
            try {
                this.factory.setSchema(schema);
            }
            catch (UnsupportedOperationException upe) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return builder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationScanTask
    implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private ServletContext sc;
        private InitFacesContext facesContext;
        private AnnotationProvider provider;
        private ProvideMetadataToAnnotationScanTask metadataGetter;
        private Set<Class<?>> annotatedSet;

        public AnnotationScanTask(ServletContext sc, InitFacesContext facesContext, ProvideMetadataToAnnotationScanTask metadataGetter) {
            this.facesContext = facesContext;
            this.provider = AnnotationProviderFactory.createAnnotationProvider(sc);
            this.metadataGetter = metadataGetter;
            this.annotatedSet = (Set)sc.getAttribute("com.sun.faces.AnnotatedClasses");
        }

        @Override
        public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
            Timer t = Timer.getInstance();
            if (t != null) {
                t.startTiming();
            }
            this.facesContext.callSetCurrentInstance();
            Set scanUris = null;
            AnnotationScanner annotationScanner = this.metadataGetter.getAnnotationScanner();
            if (this.provider instanceof DelegatingAnnotationProvider && null != annotationScanner) {
                ((DelegatingAnnotationProvider)this.provider).setAnnotationScanner(annotationScanner, this.metadataGetter.getJarNames(this.annotatedSet));
                scanUris = Collections.emptySet();
            } else {
                scanUris = this.metadataGetter.getAnnotationScanURIs(this.annotatedSet);
            }
            Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = this.provider.getAnnotatedClasses(scanUris);
            if (t != null) {
                t.stopTiming();
                t.logResult("Configuration annotation scan complete.");
            }
            return annotatedClasses;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProvideMetadataToAnnotationScanTask {
        DocumentInfo[] documentInfos;
        InjectionProvider containerConnector;
        Set<URI> uris = null;
        Set<String> jarNames = null;

        private ProvideMetadataToAnnotationScanTask(DocumentInfo[] documentInfos, InjectionProvider containerConnector) {
            this.documentInfos = documentInfos;
            this.containerConnector = containerConnector;
        }

        private void initializeIvars(Set<Class<?>> annotatedSet) {
            if (null != this.uris || null != this.jarNames) {
                assert (null != this.uris && null != this.jarNames);
                return;
            }
            this.uris = new HashSet<URI>(this.documentInfos.length);
            this.jarNames = new HashSet<String>(this.documentInfos.length);
            for (DocumentInfo docInfo : this.documentInfos) {
                String jarName;
                URI sourceURI = docInfo.getSourceURI();
                Matcher m = JAR_PATTERN.matcher(sourceURI.toString());
                if (!m.matches() || this.jarNames.contains(jarName = m.group(2))) continue;
                FacesConfigInfo configInfo = new FacesConfigInfo(docInfo);
                if (!configInfo.isMetadataComplete()) {
                    this.uris.add(sourceURI);
                    this.jarNames.add(jarName);
                    continue;
                }
                ArrayList toRemove = new ArrayList(1);
                String sourceURIString = sourceURI.toString();
                if (annotatedSet == null) continue;
                for (Class clazz : annotatedSet) {
                    if (!sourceURIString.contains(clazz.getProtectionDomain().getCodeSource().getLocation().toString())) continue;
                    toRemove.add(clazz);
                }
                annotatedSet.removeAll(toRemove);
            }
        }

        private Set<URI> getAnnotationScanURIs(Set<Class<?>> annotatedSet) {
            this.initializeIvars(annotatedSet);
            return this.uris;
        }

        private Set<String> getJarNames(Set<Class<?>> annotatedSet) {
            this.initializeIvars(annotatedSet);
            return this.jarNames;
        }

        private AnnotationScanner getAnnotationScanner() {
            AnnotationScanner result = null;
            if (this.containerConnector instanceof AnnotationScanner) {
                result = (AnnotationScanner)((Object)this.containerConnector);
            }
            return result;
        }
    }
}

