/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.monitoring.JdbcRAConstants;
import com.sun.gjc.monitoring.SQLTraceProbeProvider;
import com.sun.gjc.util.SQLTraceLogger;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;

public class SQLTraceDelegator
implements SQLTraceListener {
    protected List<SQLTraceListener> sqlTraceListenersList;
    private String poolName;
    private String appName;
    private String moduleName;
    private static final Logger logger = LogDomains.getLogger(SQLTraceLogger.class, "javax.enterprise.resource.sqltrace");
    private SQLTraceProbeProvider probeProvider = null;

    public SQLTraceProbeProvider getProbeProvider() {
        return this.probeProvider;
    }

    public SQLTraceDelegator(String poolName, String appName, String moduleName) {
        this.poolName = poolName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.probeProvider = new SQLTraceProbeProvider();
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void registerSQLTraceListener(SQLTraceListener listener) {
        if (this.sqlTraceListenersList == null) {
            this.sqlTraceListenersList = new ArrayList<SQLTraceListener>();
        }
        for (SQLTraceListener test : this.sqlTraceListenersList) {
            if (!test.getClass().equals(listener.getClass())) continue;
            return;
        }
        this.sqlTraceListenersList.add(listener);
    }

    @Override
    public void sqlTrace(SQLTraceRecord record) {
        if (record != null) {
            Object[] params;
            String methodName;
            record.setPoolName(this.poolName);
            if (this.sqlTraceListenersList != null) {
                for (SQLTraceListener listener : this.sqlTraceListenersList) {
                    try {
                        listener.sqlTrace(record);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "SQL Trace Listener threw exception", t);
                    }
                }
            }
            if (this.isMethodValidForCaching(methodName = record.getMethodName()) && (params = record.getParams()) != null && params.length > 0) {
                Object param;
                String sqlQuery = null;
                int n = 0;
                Object[] objectArray = params;
                int n2 = objectArray.length;
                if (n < n2 && (param = objectArray[n]) instanceof String) {
                    sqlQuery = param.toString();
                }
                if (sqlQuery != null) {
                    this.probeProvider.traceSQLEvent(this.poolName, this.appName, this.moduleName, sqlQuery);
                }
            }
        }
    }

    private boolean isMethodValidForCaching(String methodName) {
        return JdbcRAConstants.validSqlTracingMethodNames.contains(methodName);
    }
}

