/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeFlowInSplitExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JDBCQueryConstants;
import fish.payara.jbatch.persistence.rdbms.OracleJDBCConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JBatchJDBCPersistenceManager
implements IPersistenceManagerService,
JDBCQueryConstants,
OracleJDBCConstants {
    private static final String CLASSNAME = JBatchJDBCPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String schema = "";
    protected Map<String, String> tableNames;
    protected Map<String, String> queryStrings;
    protected Map<String, String> createDerbyStrings;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException(e);
        }
        this.tableNames = this.getSharedTableMap(batchConfig);
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException(e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            if (!this.isDerbySchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkDerbyTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    public String setDefaultSchema() throws SQLException {
        logger.finest("Entering setDefaultSchema");
        Connection connection = null;
        logger.finest("J2EE mode, getting connection from data source");
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData dbmd = null;
            dbmd = connection.getMetaData();
            this.schema = dbmd.getUserName();
            if (dbmd.getDatabaseProductName().toLowerCase().contains("mysql")) {
                this.schema = "test";
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        finally {
            this.cleanupConnection(connection, null, null);
        }
        logger.finest("Exiting setDefaultSchema");
        return this.schema;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isDerbySchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isDerbySchemaValid");
        Connection conn = null;
        DatabaseMetaData dbmd = null;
        ResultSet rs = null;
        try {
            conn = this.getConnectionToDefaultSchema();
            dbmd = conn.getMetaData();
            rs = dbmd.getSchemas();
            while (rs.next()) {
                String schemaname = rs.getString("TABLE_SCHEM");
                if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                logger.exiting(CLASSNAME, "isSchemaValid", true);
                boolean bl = true;
                this.cleanupConnection(conn, rs, null);
                return bl;
            }
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, null);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isDerbySchemaValid", false);
        return false;
    }

    private void checkDerbyTables() throws SQLException {
        this.setCreateDerbyStringsMap(this.batchConfig);
        this.createDerbyTableNotExists(this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_CHECKPOINTDATA"));
        this.createDerbyTableNotExists(this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createDerbyTableNotExists(this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createDerbyTableNotExists(this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createDerbyTableNotExists(this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_JOBSTATUS"));
        this.createDerbyTableNotExists(this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createDerbyStrings.get("DERBY_CREATE_TABLE_STEPSTATUS"));
    }

    protected void createDerbyTableNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createIfNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = null;
        DatabaseMetaData dbmd = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, this.schema, tableName, null);
            if (!rs.next()) {
                logger.log(Level.INFO, tableName + " table does not exists. Trying to create it.");
                ps = conn.prepareStatement(createTableStatement);
                ps.executeUpdate();
            }
            this.cleanupConnection(conn, rs, ps);
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, ps);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createIfNotExists");
    }

    public int getTableRowCount(ResultSet rs) throws SQLException {
        int rowcount = 0;
        try {
            if (rs.last()) {
                rowcount = rs.getRow();
                rs.beforeFirst();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        return rowcount;
    }

    protected void executeStatement(String statement) throws SQLException {
        logger.entering(CLASSNAME, "executeStatement", statement);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(statement);
            ps.executeUpdate();
            this.cleanupConnection(conn, ps);
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, ps);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "executeStatement");
    }

    @Override
    public void createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "createCheckpointData", new Object[]{key, value});
        this.insertCheckpointData(key.getCommaSeparatedKey(), value);
        logger.exiting(CLASSNAME, "createCheckpointData");
    }

    @Override
    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "getCheckpointData", key == null ? "<null>" : key);
        CheckpointData checkpointData = this.queryCheckpointData(key.getCommaSeparatedKey());
        logger.exiting(CLASSNAME, "getCheckpointData", checkpointData == null ? "<null>" : checkpointData);
        return checkpointData;
    }

    @Override
    public void updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        CheckpointData data = this.queryCheckpointData(key.getCommaSeparatedKey());
        if (data != null) {
            this.updateCheckpointData(key.getCommaSeparatedKey(), value);
        } else {
            this.createCheckpointData(key, value);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    protected Connection getConnection() throws SQLException {
        logger.finest("Entering: " + CLASSNAME + ".getConnection");
        Connection connection = null;
        logger.finest("J2EE mode, getting connection from data source");
        connection = this.dataSource.getConnection();
        logger.finest("autocommit=" + connection.getAutoCommit());
        this.setSchemaOnConnection(connection);
        logger.finest("Exiting: " + CLASSNAME + ".getConnection() with conn =" + connection);
        return connection;
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        logger.finest("Entering getConnectionToDefaultSchema");
        Connection connection = null;
        logger.finest("J2EE mode, getting connection from data source");
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.logException("FAILED GETTING DATABASE CONNECTION", e);
            throw new PersistenceException(e);
        }
        logger.finest("autocommit=" + connection.getAutoCommit());
        logger.finest("Exiting from getConnectionToDefaultSchema, conn= " + connection);
        return connection;
    }

    protected void logException(String msg, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        logger.log(Level.SEVERE, msg + "; Exception stack trace: " + sw);
    }

    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.finest("Entering " + CLASSNAME + ".setSchemaOnConnection()");
        String productname = connection.getMetaData().getDatabaseProductName();
        if (!productname.contains("Oracle")) {
            PreparedStatement ps = null;
            ps = connection.prepareStatement(this.queryStrings.get("Q_SET_SCHEMA"));
            ps.setString(1, this.schema);
            ps.executeUpdate();
            ps.close();
        }
        logger.finest("Exiting " + CLASSNAME + ".setSchemaOnConnection()");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckpointData queryCheckpointData(Object key) {
        CheckpointData data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            logger.entering(CLASSNAME, "queryCheckpointData", new Object[]{key, "SELECT_CHECKPOINTDATA"});
            conn = null;
            statement = null;
            rs = null;
            ObjectInputStream objectIn = null;
            data = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(this.queryStrings.get("SELECT_CHECKPOINTDATA"));
                statement.setObject(1, key);
                rs = statement.executeQuery();
                if (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    data = (CheckpointData)this.deserializeObject(buf);
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "queryCheckpointData");
        return data;
    }

    protected <T> void insertCheckpointData(Object key, T value) {
        logger.entering(CLASSNAME, "insertCheckpointData", new Object[]{key, value});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("INSERT_CHECKPOINTDATA"));
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setBytes(2, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "insertCheckpointData");
    }

    protected void updateCheckpointData(Object key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_CHECKPOINTDATA"));
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            logger.severe(e.getLocalizedMessage());
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    protected void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, rs == null ? "<null>" : rs, statement == null ? "<null>" : statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    protected void cleanupConnection(Connection conn, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName, String appTag) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOBOPERATOR_GET_JOB_INSTANCE_COUNT"));
            statement.setString(1, jobName);
            statement.setString(2, appTag);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_COUNT"));
            statement.setString(1, jobName);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, String appTag, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOBOPERATOR_GET_JOB_INSTANCE_IDS"));
            statement.setObject(1, jobName);
            statement.setObject(2, appTag);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_IDS"));
            statement.setObject(1, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    @Override
    public Map<Long, String> jobOperatorGetExternalJobInstanceData() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashMap<Long, String> data = new HashMap<Long, String>();
        try {
            conn = this.getConnection();
            String filter = "not like ':%'";
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_EXTERNAL_JOB_INSTANCE_DATA") + "not like ':%'");
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                String name = rs.getString("name");
                data.put(id, name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, IPersistenceManagerService.TimestampType timestampType) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp createTimestamp = null;
        Timestamp endTimestamp = null;
        Timestamp updateTimestamp = null;
        Timestamp startTimestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_TIMESTAMP"));
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                createTimestamp = rs.getTimestamp(1);
                endTimestamp = rs.getTimestamp(2);
                updateTimestamp = rs.getTimestamp(3);
                startTimestamp = rs.getTimestamp(4);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.CREATE)) {
            return createTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.END)) {
            return endTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.LAST_UPDATED)) {
            return updateTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.STARTED)) {
            return startTimestamp;
        }
        throw new IllegalArgumentException("Unexpected enum value.");
    }

    @Override
    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_BATCH_STATUS"));
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_EXIT_STATUS"));
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) throws NoSuchJobExecutionException {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_JOB_ID"));
            statement.setLong(1, executionID);
            rs = statement.executeQuery();
            if (!rs.next()) {
                String msg = "Did not find job instance associated with executionID =" + executionID;
                logger.fine(msg);
                throw new NoSuchJobExecutionException(msg);
            }
            jobinstanceID = rs.getLong("jobinstanceid");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobinstanceID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        Properties props;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            props = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(this.queryStrings.get("GET_PARAMETERS"));
                statement.setLong(1, executionId);
                rs = statement.executeQuery();
                if (!rs.next()) {
                    String msg = "Did not find table entry for executionID =" + executionId;
                    logger.fine(msg);
                    throw new NoSuchJobExecutionException(msg);
                }
                byte[] buf = rs.getBytes("parameters");
                props = (Properties)this.deserializeObject(buf);
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return props;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, StepExecution> getMostRecentStepExecutionsForJobInstance(long instanceId) {
        HashMap<String, StepExecution> data = new HashMap<String, StepExecution>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("MOST_RECENT_STEPS_FOR_JOB"));
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                stepname = rs.getString("stepname");
                if (data.containsKey(stepname)) continue;
                jobexecid = rs.getLong("jobexecid");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf(batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                data.put(stepname, stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        ArrayList<StepExecution> data = new ArrayList<StepExecution>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("STEP_EXECUTIONS_FOR_JOB_EXECUTION"));
            statement.setLong(1, execid);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                jobexecid = rs.getLong("jobexecid");
                stepexecid = rs.getLong("stepexecid");
                stepname = rs.getString("stepname");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf(batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                logger.fine("BatchStatus: " + batchstatus + " | StepName: " + stepname + " | JobExecID: " + jobexecid + " | StepExecID: " + stepexecid);
                data.add(stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("STEP_EXECUTIONS_BY_STEP_ID"));
            statement.setLong(1, stepExecId);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return stepEx;
                }
                jobexecid = rs.getLong("jobexecid");
                stepexecid = rs.getLong("stepexecid");
                stepname = rs.getString("stepname");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf(batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                logger.fine("stepExecution BatchStatus: " + batchstatus + " StepName: " + stepname);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateBatchStatusOnly(long key, BatchStatus batchStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_BATCH_STATUS_ONLY"));
            statement.setString(1, batchStatus.name());
            statement.setTimestamp(2, updatets);
            statement.setLong(3, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    @Override
    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_FINAL_STATUS_AND_TIMESTAMP"));
            statement.setString(1, batchStatus.name());
            statement.setString(2, exitStatus);
            statement.setTimestamp(3, updatets);
            statement.setTimestamp(4, updatets);
            statement.setLong(5, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("MARK_JOB_STARTED"));
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setTimestamp(2, startTS);
            statement.setTimestamp(3, startTS);
            statement.setLong(4, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        IJobExecution jobEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block11: {
            conn = null;
            statement = null;
            rs = null;
            jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_JOB_EXECUTION"));
                statement.setLong(1, jobExecutionId);
                rs = statement.executeQuery();
                IJobExecution iJobExecution = jobEx = rs.next() ? this.readJobExecutionRecord(rs) : null;
                if (objectIn == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return jobEx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        ArrayList<IJobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<IJobExecution>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_JOB_EXECUTIONS"));
                statement.setLong(1, jobInstanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    data.add(this.readJobExecutionRecord(rs));
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    protected IJobExecution readJobExecutionRecord(ResultSet rs) throws SQLException, IOException, ClassNotFoundException {
        if (rs == null) {
            return null;
        }
        JobOperatorJobExecution retMe = new JobOperatorJobExecution(rs.getLong("jobexecid"), rs.getLong("jobinstanceid"));
        retMe.setCreateTime(rs.getTimestamp("createtime"));
        retMe.setStartTime(rs.getTimestamp("starttime"));
        retMe.setEndTime(rs.getTimestamp("endtime"));
        retMe.setLastUpdateTime(rs.getTimestamp("updatetime"));
        retMe.setJobParameters((Properties)this.deserializeObject(rs.getBytes("parameters")));
        retMe.setBatchStatus(rs.getString("batchstatus"));
        retMe.setExitStatus(rs.getString("exitstatus"));
        retMe.setJobName(rs.getString("name"));
        return retMe;
    }

    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<Long> executionIds = new HashSet<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_RUNNING_EXECUTIONS"));
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setString(2, BatchStatus.STARTING.name());
            statement.setString(3, BatchStatus.STOPPING.name());
            statement.setString(4, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                executionIds.add(rs.getLong("jobexecid"));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return executionIds;
    }

    @Override
    public String getJobCurrentTag(long jobInstanceId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String apptag = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_APPTAG"));
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            while (rs.next()) {
                apptag = rs.getString("apptag");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return apptag;
    }

    @Override
    public void purge(String apptag) {
        logger.entering(CLASSNAME, "purge", apptag);
        String deleteJobs = this.queryStrings.get("DELETE_JOBS");
        String deleteJobExecutions = this.queryStrings.get("DELETE_JOB_EXECUTIONS");
        String deleteStepExecutions = this.queryStrings.get("DELETE_STEP_EXECUTIONS");
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(deleteStepExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobs);
            statement.setString(1, apptag);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "purge");
    }

    @Override
    public JobStatus getJobStatusFromExecution(long executionId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobStatus retVal = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("GET_JOB_STATUS_FROM_EXECUTIONS"));
            statement.setLong(1, executionId);
            rs = statement.executeQuery();
            byte[] buf = null;
            if (rs.next()) {
                buf = rs.getBytes("obj");
            }
            retVal = (JobStatus)this.deserializeObject(buf);
            this.cleanupConnection(conn, rs, statement);
        }
        catch (Exception e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "executeQuery");
        return retVal;
    }

    @Override
    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        long instanceId = 0L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("JOB_INSTANCE_ID_BY_EXECUTION_ID"));
            statement.setObject(1, executionId);
            rs = statement.executeQuery();
            if (!rs.next()) {
                String msg = "Did not find job instance associated with executionID =" + executionId;
                logger.fine(msg);
                throw new NoSuchJobExecutionException(msg);
            }
            instanceId = rs.getLong("jobinstanceid");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return instanceId;
    }

    protected byte[] serializeObject(Serializable theObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(theObject);
        byte[] data = baos.toByteArray();
        baos.close();
        oout.close();
        return data;
    }

    protected Serializable deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        Serializable theObject = null;
        ObjectInputStream objectIn = null;
        if (buffer != null) {
            objectIn = new ObjectInputStream(new ByteArrayInputStream(buffer));
            theObject = (Serializable)objectIn.readObject();
            objectIn.close();
        }
        return theObject;
    }

    @Override
    public JobInstance createSubJobInstance(String name, String apptag) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("CREATE_SUB_JOB_INSTANCE"), new String[]{"JOBINSTANCEID"});
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobInstanceID);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    @Override
    public JobInstance createJobInstance(String name, String apptag, String jobXml) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOB_INSTANCE"), new String[]{"JOBINSTANCEID"});
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobInstanceID, jobXml);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    @Override
    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, jobParameters, batchStatus, now);
        RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, newExecutionId);
        jobExecution.setBatchStatus(batchStatus.name());
        jobExecution.setCreateTime(now);
        jobExecution.setLastUpdateTime(now);
        return jobExecution;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp timestamp) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long newJobExecutionId = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOB_EXECUTION_ENTRY"), new String[]{"JOBEXECID"});
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, timestamp);
            statement.setTimestamp(3, timestamp);
            statement.setString(4, batchStatus.name());
            statement.setObject(5, this.serializeObject(jobParameters));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                newJobExecutionId = rs.getLong(1);
            }
            this.cleanupConnection(conn, rs, statement);
            return newJobExecutionId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, null, batchStatus, now);
        RuntimeFlowInSplitExecution flowExecution = new RuntimeFlowInSplitExecution(jobInstance, newExecutionId);
        flowExecution.setBatchStatus(batchStatus.name());
        flowExecution.setCreateTime(now);
        flowExecution.setLastUpdateTime(now);
        return flowExecution;
    }

    @Override
    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        StepExecutionImpl stepExecution = null;
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("batchStatus: " + batchStatus + " | stepName: " + stepName);
        }
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        stepExecution = this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
        return stepExecution;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "createStepExecution", new Object[]{rootJobExecId, batchStatus, exitStatus == null ? "<null>" : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? "<null>" : startTime, endTime == null ? "<null>" : endTime, persistentData == null ? "<null>" : persistentData});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        StepExecutionImpl stepExecution = null;
        String query = this.queryStrings.get("CREATE_STEP_EXECUTION");
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query, new String[]{"STEPEXECID"});
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, this.serializeObject(persistentData));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long stepExecutionId = rs.getLong(1);
                stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                stepExecution.setStepName(stepName);
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createStepExecution");
        return stepExecution;
    }

    @Override
    public void updateStepExecution(StepContextImpl stepContext) {
        Metric[] metrics = stepContext.getMetrics();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    protected String getPartitionLevelJobInstanceWildCard(long rootJobExecutionId, String stepName) {
        long jobInstanceId = this.getJobInstanceIdByExecutionId(rootJobExecutionId);
        StringBuilder sb = new StringBuilder(":");
        sb.append(Long.toString(jobInstanceId));
        sb.append(":");
        sb.append(stepName);
        sb.append(":%");
        return sb.toString();
    }

    @Override
    public void updateWithFinalPartitionAggregateStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_WITH_FINAL_PARTITION_STEP_EXECUTION"));
            statement.setString(1, this.getPartitionLevelJobInstanceWildCard(rootJobExecutionId, stepContext.getStepName()));
            rs = statement.executeQuery();
            if (rs.next()) {
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    protected void updateStepExecutionWithMetrics(StepContextImpl stepContext, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount) {
        long stepExecutionId = stepContext.getInternalStepExecutionId();
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("batchStatus: " + batchStatus + " | stepName: " + stepName + " | stepExecID: " + stepContext.getStepExecutionId());
        }
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Serializable persistentData = stepContext.getPersistentUserData();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "About to update StepExecution with: ", new Object[]{stepExecutionId, batchStatus, exitStatus == null ? "<null>" : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? "<null>" : startTime, endTime == null ? "<null>" : endTime, persistentData == null ? "<null>" : persistentData});
        }
        Connection conn = null;
        PreparedStatement statement = null;
        String query = this.queryStrings.get("UPDATE_STEP_EXECUTION_WITH_METRICS");
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setString(1, batchStatus);
            statement.setString(2, exitStatus);
            statement.setString(3, stepName);
            statement.setLong(4, readCount);
            statement.setLong(5, writeCount);
            statement.setLong(6, commitCount);
            statement.setLong(7, rollbackCount);
            statement.setLong(8, readSkipCount);
            statement.setLong(9, processSkipCount);
            statement.setLong(10, filterCount);
            statement.setLong(11, writeSkipCount);
            statement.setTimestamp(12, startTime);
            statement.setTimestamp(13, endTime);
            statement.setObject(14, this.serializeObject(persistentData));
            statement.setLong(15, stepExecutionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        logger.entering(CLASSNAME, "createJobStatus", jobInstanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        JobStatus jobStatus = new JobStatus(jobInstanceId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOBSTATUS"));
            statement.setLong(1, jobInstanceId);
            statement.setBytes(2, this.serializeObject(jobStatus));
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createJobStatus");
        return jobStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobStatus getJobStatus(long instanceId) {
        logger.entering(CLASSNAME, "getJobStatus", instanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = this.queryStrings.get("GET_JOB_STATUS");
        JobStatus jobStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                jobStatus = (JobStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getJobStatus", jobStatus);
        return jobStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        logger.entering(CLASSNAME, "updateJobStatus", new Object[]{instanceId, jobStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating Job Status to: " + (Object)((Object)jobStatus.getBatchStatus()));
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_JOBSTATUS"));
            statement.setBytes(1, this.serializeObject(jobStatus));
            statement.setLong(2, instanceId);
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "updateJobStatus");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepStatus createStepStatus(long stepExecId) {
        logger.entering(CLASSNAME, "createStepStatus", stepExecId);
        Connection conn = null;
        PreparedStatement statement = null;
        StepStatus stepStatus = new StepStatus(stepExecId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("CREATE_STEP_STATUS"));
            statement.setLong(1, stepExecId);
            statement.setBytes(2, this.serializeObject(stepStatus));
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createStepStatus");
        return stepStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        logger.entering(CLASSNAME, "getStepStatus", new Object[]{instanceId, stepName});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = this.queryStrings.get("GET_STEP_STATUS");
        StepStatus stepStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            statement.setString(2, stepName);
            rs = statement.executeQuery();
            if (rs.next()) {
                stepStatus = (StepStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getStepStatus", stepStatus == null ? "<null>" : stepStatus);
        return stepStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        logger.entering(CLASSNAME, "updateStepStatus", new Object[]{stepExecutionId, stepStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating StepStatus to: " + (Object)((Object)stepStatus.getBatchStatus()));
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.queryStrings.get("UPDATE_STEP_STATUS"));
            statement.setBytes(1, this.serializeObject(stepStatus));
            statement.setLong(2, stepExecutionId);
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "updateStepStatus");
    }

    @Override
    public String getTagName(long jobExecutionId) {
        logger.entering(CLASSNAME, "getTagName", jobExecutionId);
        String apptag = null;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = this.queryStrings.get("GET_TAGNAME");
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobExecutionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                apptag = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getTagName");
        return apptag;
    }

    @Override
    public long getMostRecentExecutionId(long jobInstanceId) {
        logger.entering(CLASSNAME, "getMostRecentExecutionId", jobInstanceId);
        long mostRecentId = -1L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = this.queryStrings.get("GET_MOST_RECENT_EXECUTION_ID");
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                mostRecentId = rs.getLong(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getMostRecentExecutionId");
        return mostRecentId;
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    protected Map<String, String> getSharedTableMap(IBatchConfig batchConfig) {
        String prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        String suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        HashMap<String, String> result = new HashMap<String, String>(6);
        result.put("JOB_INSTANCE_TABLE_KEY", prefix + "JOBINSTANCEDATA" + suffix);
        result.put("EXECUTION_INSTANCE_TABLE_KEY", prefix + "EXECUTIONINSTANCEDATA" + suffix);
        result.put("STEP_EXECUTION_INSTANCE_TABLE_KEY", prefix + "STEPEXECUTIONINSTANCEDATA" + suffix);
        result.put("JOB_STATUS_TABLE_KEY", prefix + "JOBSTATUS" + suffix);
        result.put("STEP_STATUS_TABLE_KEY", prefix + "STEPSTATUS" + suffix);
        result.put("CHECKPOINT_TABLE_KEY", prefix + "CHECKPOINTDATA" + suffix);
        return result;
    }

    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        this.queryStrings = new HashMap<String, String>();
        this.queryStrings.put("Q_SET_SCHEMA", "SET SCHEMA ?");
        this.queryStrings.put("SELECT_CHECKPOINTDATA", "select id, obj from " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " where id = ?");
        this.queryStrings.put("INSERT_CHECKPOINTDATA", "insert into " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " values(?, ?)");
        this.queryStrings.put("UPDATE_CHECKPOINTDATA", "update " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " set obj = ? where id = ?");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ?");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_IDS", "select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ? order by jobinstanceid desc");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_IDS", "select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? order by jobinstanceid desc");
        this.queryStrings.put("JOB_OPERATOR_GET_EXTERNAL_JOB_INSTANCE_DATA", "select distinct jobinstanceid, name from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name ");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_TIMESTAMP", "select createtime, endtime, updatetime, starttime from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_BATCH_STATUS", "select batchstatus from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_EXIT_STATUS", "select exitstatus from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_JOB_ID", "select jobinstanceid from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("GET_PARAMETERS", "select parameters from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("MOST_RECENT_STEPS_FOR_JOB", "select A.* from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
        this.queryStrings.put("STEP_EXECUTIONS_FOR_JOB_EXECUTION", "select * from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("STEP_EXECUTIONS_BY_STEP_ID", "select * from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where stepexecid = ?");
        this.queryStrings.put("UPDATE_BATCH_STATUS_ONLY", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("UPDATE_FINAL_STATUS_AND_TIMESTAMP", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, exitstatus = ?, endtime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("MARK_JOB_STARTED", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, starttime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTION", "select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTIONS", "select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_RUNNING_EXECUTIONS", "SELECT A.jobexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid WHERE A.batchstatus IN (?,?,?) AND B.name = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_APPTAG", "select apptag from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where jobinstanceid = ?");
        this.queryStrings.put("DELETE_JOBS", "DELETE FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " WHERE apptag = ?");
        String deleteJobExecutions = "DELETE FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " " + "WHERE jobexecid IN (" + "SELECT B.jobexecid FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B " + "ON A.jobinstanceid = B.jobinstanceid " + "WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_JOB_EXECUTIONS", deleteJobExecutions);
        String deleteStepExecutions = "DELETE FROM " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " " + "WHERE stepexecid IN (" + "SELECT C.stepexecid FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B " + "ON A.jobinstanceid = B.jobinstanceid INNER JOIN " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " C " + "ON B.jobexecid = C.jobexecid " + "WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_STEP_EXECUTIONS", deleteStepExecutions);
        this.queryStrings.put("GET_JOB_STATUS_FROM_EXECUTIONS", "select A.obj from " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " as A inner join " + "" + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.id = B.jobinstanceid where B.jobexecid = ?");
        this.queryStrings.put("JOB_INSTANCE_ID_BY_EXECUTION_ID", "select jobinstanceid from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("CREATE_SUB_JOB_INSTANCE", "INSERT INTO " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_INSTANCE", "INSERT INTO " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_EXECUTION_ENTRY", "INSERT INTO " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobinstanceid, createtime, updatetime, batchstatus, parameters) VALUES(?, ?, ?, ?, ?)");
        this.queryStrings.put("CREATE_STEP_EXECUTION", "INSERT INTO " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid, batchstatus, exitstatus, stepname, readcount," + "writecount, commitcount, rollbackcount, readskipcount, processskipcount, filtercount, writeskipcount, starttime," + "endtime, persistentdata) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.queryStrings.put("UPDATE_WITH_FINAL_PARTITION_STEP_EXECUTION", "select SUM(STEPEX.readcount) readcount, SUM(STEPEX.writecount) writecount, SUM(STEPEX.commitcount) commitcount,  SUM(STEPEX.rollbackcount) rollbackcount, SUM(STEPEX.readskipcount) readskipcount, SUM(STEPEX.processskipcount) processskipcount, SUM(STEPEX.filtercount) filtercount, SUM(STEPEX.writeSkipCount) writeSkipCount from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " STEPEX inner join " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " JOBEX" + " on STEPEX.jobexecid = JOBEX.jobexecid" + " where JOBEX.jobinstanceid IN" + " (select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name like ?)");
        this.queryStrings.put("UPDATE_STEP_EXECUTION_WITH_METRICS", "UPDATE " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " SET batchstatus = ?, exitstatus = ?, stepname = ?,  readcount = ?," + "writecount = ?, commitcount = ?, rollbackcount = ?, readskipcount = ?, processskipcount = ?, filtercount = ?, writeskipcount = ?," + " starttime = ?, endtime = ?, persistentdata = ? WHERE stepexecid = ?");
        this.queryStrings.put("CREATE_JOBSTATUS", "INSERT INTO " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_JOB_STATUS", "SELECT obj FROM " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " WHERE id = ?");
        this.queryStrings.put("UPDATE_JOBSTATUS", "UPDATE " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("CREATE_STEP_STATUS", "INSERT INTO " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_STEP_STATUS", "SELECT obj FROM " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " WHERE id IN (" + "SELECT B.stepexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobexecid = B.jobexecid " + "WHERE A.jobinstanceid = ? and B.stepname = ?)");
        this.queryStrings.put("UPDATE_STEP_STATUS", "UPDATE " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("GET_TAGNAME", "SELECT A.apptag FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid" + " WHERE B.jobexecid = ?");
        this.queryStrings.put("GET_MOST_RECENT_EXECUTION_ID", "SELECT jobexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " WHERE jobinstanceid = ? ORDER BY createtime DESC");
        return this.queryStrings;
    }

    protected Map<String, String> setCreateDerbyStringsMap(IBatchConfig batchConfig) {
        this.createDerbyStrings = new HashMap<String, String>();
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id VARCHAR(512),obj BLOB)");
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(" + "jobinstanceid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBINSTANCE_PK PRIMARY KEY," + "name VARCHAR(512)," + "apptag VARCHAR(512))");
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(" + "jobexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBEXECUTION_PK PRIMARY KEY," + "jobinstanceid BIGINT," + "createtime TIMESTAMP," + "starttime TIMESTAMP," + "endtime TIMESTAMP," + "updatetime TIMESTAMP," + "parameters BLOB," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(" + "stepexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT STEPEXECUTION_PK PRIMARY KEY," + "jobexecid BIGINT," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "stepname VARCHAR(512)," + "readcount INTEGER," + "writecount INTEGER," + "commitcount INTEGER," + "rollbackcount INTEGER," + "readskipcount INTEGER," + "processskipcount INTEGER," + "filtercount INTEGER," + "writeskipcount INTEGER," + "startTime TIMESTAMP," + "endTime TIMESTAMP," + "persistentData BLOB," + "CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + "(" + "id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY," + "obj BLOB," + "CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createDerbyStrings.put("DERBY_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + "(" + "id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY," + "obj BLOB," + "CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid) ON DELETE CASCADE)");
        return this.createDerbyStrings;
    }
}

