/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc;

import com.sun.gjc.util.SQLTraceLogger;
import com.sun.logging.LogDomains;
import fish.payara.jdbc.SQLQuery;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;

public class SlowSQLLogger
implements SQLTraceListener {
    private static final Logger logger = LogDomains.getLogger(SQLTraceLogger.class, "javax.enterprise.resource.sqltrace");
    private static ThreadLocal<SQLQuery> currentQuery = new ThreadLocal();
    private long threshold = 10000L;

    public SlowSQLLogger(long threshold) {
        this.threshold = threshold;
    }

    public SlowSQLLogger() {
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    @Override
    public void sqlTrace(SQLTraceRecord record) {
        if (record != null) {
            switch (record.getMethodName()) {
                case "nativeSQL": 
                case "prepareCall": 
                case "prepareStatement": 
                case "addBatch": {
                    SQLQuery query = currentQuery.get();
                    if (query == null) {
                        query = new SQLQuery();
                        currentQuery.set(query);
                    }
                    if (record.getParams() == null || record.getParams().length <= 0) break;
                    query.addSQL((String)record.getParams()[0]);
                    break;
                }
                case "execute": 
                case "executeQuery": 
                case "executeUpdate": {
                    SQLQuery query = currentQuery.get();
                    if (query == null) {
                        query = new SQLQuery();
                        currentQuery.set(query);
                    }
                    long executionTime = record.getExecutionTime();
                    if (record.getParams() != null && record.getParams().length > 0) {
                        query.addSQL((String)record.getParams()[0]);
                    }
                    if (executionTime > this.threshold) {
                        StringBuilder messageBuilder = new StringBuilder("SQL Query Exceeded Threshold Time: ");
                        messageBuilder.append(this.threshold).append("(ms): Time Taken: ").append(executionTime).append("(ms)\n").append("Query was ").append(query.getSQL());
                        logger.log(Level.WARNING, messageBuilder.toString(), new Exception("Stack Trace shows code path to SQL"));
                    }
                    currentQuery.set(null);
                    break;
                }
            }
        }
    }
}

