/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import com.sun.enterprise.glassfish.bootstrap.StaticGlassFishRuntime;
import fish.payara.micro.BootstrapException;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.PortBinder;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.hazelcast.MulticastConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class PayaraMicro {
    private static final Logger logger = Logger.getLogger("PayaraMicro");
    private static PayaraMicro instance;
    private String hzMulticastGroup;
    private int hzPort = Integer.MIN_VALUE;
    private int hzStartPort = Integer.MIN_VALUE;
    private int httpPort = Integer.MIN_VALUE;
    private int sslPort = Integer.MIN_VALUE;
    private int maxHttpThreads = Integer.MIN_VALUE;
    private int minHttpThreads = Integer.MIN_VALUE;
    private String instanceName = UUID.randomUUID().toString();
    private File rootDir;
    private File deploymentRoot;
    private File alternateDomainXML;
    private File alternateHZConfigFile;
    private List<File> deployments;
    private GlassFish gf;
    private PayaraMicroRuntime runtime;
    private boolean noCluster = false;
    private boolean autoBindHttp = false;
    private boolean autoBindSsl = false;
    private int autoBindRange = 5;

    public static void main(String[] args) throws BootstrapException {
        PayaraMicro main = PayaraMicro.getInstance();
        main.scanArgs(args);
        main.bootStrap();
    }

    public static PayaraMicro getInstance() {
        return PayaraMicro.getInstance(true);
    }

    public static PayaraMicroRuntime bootstrap() throws BootstrapException {
        return PayaraMicro.getInstance().bootStrap();
    }

    public static PayaraMicro getInstance(boolean create) {
        if (instance == null && create) {
            instance = new PayaraMicro();
        }
        return instance;
    }

    private PayaraMicro() {
        this.addShutdownHook();
    }

    private PayaraMicro(String[] args) {
        this.scanArgs(args);
        this.addShutdownHook();
    }

    public String getClusterMulticastGroup() {
        return this.hzMulticastGroup;
    }

    public PayaraMicro setClusterMulticastGroup(String hzMulticastGroup) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzMulticastGroup = hzMulticastGroup;
        return this;
    }

    public int getClusterPort() {
        return this.hzPort;
    }

    public PayaraMicro setClusterPort(int hzPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzPort = hzPort;
        return this;
    }

    public int getClusterStartPort() {
        return this.hzStartPort;
    }

    public PayaraMicro setClusterStartPort(int hzStartPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzStartPort = hzStartPort;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public PayaraMicro setHttpPort(int httpPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.httpPort = httpPort;
        return this;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public PayaraMicro setSslPort(int sslPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.sslPort = sslPort;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public PayaraMicro setInstanceName(String instanceName) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.instanceName = instanceName;
        return this;
    }

    public File getDeploymentDir() {
        return this.deploymentRoot;
    }

    public PayaraMicro setDeploymentDir(File deploymentRoot) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.deploymentRoot = deploymentRoot;
        return this;
    }

    public File getAlternateDomainXML() {
        return this.alternateDomainXML;
    }

    public PayaraMicro setAlternateDomainXML(File alternateDomainXML) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.alternateDomainXML = alternateDomainXML;
        return this;
    }

    public PayaraMicro addDeployment(String pathToWar) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        File file = new File(pathToWar);
        return this.addDeploymentFile(file);
    }

    public PayaraMicro addDeploymentFile(File file) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        if (this.deployments == null) {
            this.deployments = new LinkedList<File>();
        }
        this.deployments.add(file);
        return this;
    }

    public boolean isNoCluster() {
        return this.noCluster;
    }

    public PayaraMicro setNoCluster(boolean noCluster) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.noCluster = noCluster;
        return this;
    }

    public int getMaxHttpThreads() {
        return this.maxHttpThreads;
    }

    public PayaraMicro setMaxHttpThreads(int maxHttpThreads) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.maxHttpThreads = maxHttpThreads;
        return this;
    }

    public int getMinHttpThreads() {
        return this.minHttpThreads;
    }

    public PayaraMicro setMinHttpThreads(int minHttpThreads) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.minHttpThreads = minHttpThreads;
        return this;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public PayaraMicro setRootDir(File rootDir) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.rootDir = rootDir;
        return this;
    }

    public boolean getHttpAutoBind() {
        return this.autoBindHttp;
    }

    public PayaraMicro setHttpAutoBind(boolean httpAutoBind) {
        this.autoBindHttp = httpAutoBind;
        return this;
    }

    public boolean getSslAutoBind() {
        return this.autoBindSsl;
    }

    public PayaraMicro setSslAutoBind(boolean sslAutoBind) {
        this.autoBindSsl = sslAutoBind;
        return this;
    }

    public int getAutoBindRange() {
        return this.autoBindRange;
    }

    public PayaraMicro setAutoBindRange(int autoBindRange) {
        this.autoBindRange = autoBindRange;
        return this;
    }

    public PayaraMicroRuntime bootStrap() throws BootstrapException {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, calling bootstrap now is meaningless");
        }
        MulticastConfiguration mc = new MulticastConfiguration();
        mc.setMemberName(this.instanceName);
        if (this.hzPort > Integer.MIN_VALUE) {
            mc.setMulticastPort(this.hzPort);
        }
        if (this.hzStartPort > Integer.MIN_VALUE) {
            mc.setStartPort(this.hzStartPort);
        }
        if (this.hzMulticastGroup != null) {
            mc.setMulticastGroup(this.hzMulticastGroup);
        }
        if (this.alternateHZConfigFile != null) {
            mc.setAlternateConfiguration(this.alternateHZConfigFile);
        }
        HazelcastCore.setMulticastOverride(mc);
        this.setSystemProperties();
        BootstrapProperties bprops = new BootstrapProperties();
        PortBinder portBinder = new PortBinder();
        try {
            GlassFishRuntime gfruntime = GlassFishRuntime.bootstrap(bprops, Thread.currentThread().getContextClassLoader());
            GlassFishProperties gfproperties = new GlassFishProperties();
            if (this.httpPort != Integer.MIN_VALUE) {
                if (this.autoBindHttp) {
                    try {
                        gfproperties.setPort("http-listener", portBinder.findAvailablePort(this.httpPort, this.autoBindRange));
                    }
                    catch (BindException ex) {
                        Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, "No available port found in range: " + this.httpPort + " - " + (this.httpPort + this.autoBindRange), ex);
                        throw new GlassFishException("Could not bind HTTP port");
                    }
                } else {
                    gfproperties.setPort("http-listener", this.httpPort);
                }
            } else if (this.autoBindHttp) {
                try {
                    gfproperties.setPort("http-listener", portBinder.findAvailablePort(8080, this.autoBindRange));
                }
                catch (BindException ex) {
                    Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, "No available port found in range: 8080 - " + (8080 + this.autoBindRange), ex);
                    throw new GlassFishException("Could not bind HTTP port");
                }
            }
            if (this.sslPort != Integer.MIN_VALUE) {
                if (this.autoBindSsl) {
                    try {
                        gfproperties.setPort("https-listener", portBinder.findAvailablePort(this.sslPort, this.autoBindRange));
                    }
                    catch (BindException ex) {
                        Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, "No available port found in range: " + this.sslPort + " - " + (this.sslPort + this.autoBindRange), ex);
                        throw new GlassFishException("Could not bind SSL port");
                    }
                } else {
                    gfproperties.setPort("https-listener", this.sslPort);
                }
            }
            if (this.alternateDomainXML != null) {
                gfproperties.setConfigFileReadOnly(false);
                gfproperties.setConfigFileURI("file:///" + this.alternateDomainXML.getAbsolutePath().replace('\\', '/'));
            } else if (this.noCluster) {
                gfproperties.setConfigFileURI(Thread.currentThread().getContextClassLoader().getResource("microdomain-nocluster.xml").toExternalForm());
            } else {
                gfproperties.setConfigFileURI(Thread.currentThread().getContextClassLoader().getResource("microdomain.xml").toExternalForm());
            }
            if (this.rootDir != null) {
                gfproperties.setInstanceRoot(this.rootDir.getAbsolutePath());
                File configFile = new File(this.rootDir.getAbsolutePath() + File.separator + "config" + File.separator + "domain.xml");
                if (!configFile.exists()) {
                    this.installFiles(gfproperties);
                } else {
                    String absolutePath = this.rootDir.getAbsolutePath();
                    absolutePath = absolutePath.replace('\\', '/');
                    gfproperties.setConfigFileURI("file:///" + absolutePath + "/config/domain.xml");
                    gfproperties.setConfigFileReadOnly(false);
                }
            }
            if (this.maxHttpThreads != Integer.MIN_VALUE) {
                gfproperties.setProperty("embedded-glassfish-config.server.thread-pools.thread-pool.http-thread-pool.max-thread-pool-size", Integer.toString(this.maxHttpThreads));
            }
            if (this.minHttpThreads != Integer.MIN_VALUE) {
                gfproperties.setProperty("embedded-glassfish-config.server.thread-pools.thread-pool.http-thread-pool.min-thread-pool-size", Integer.toString(this.minHttpThreads));
            }
            this.gf = gfruntime.newGlassFish(gfproperties);
            File configDir = new File(System.getProperty("com.sun.aas.instanceRoot"), "config");
            File loggingProperties = new File(configDir.getAbsolutePath(), "logging.properties");
            if (loggingProperties.exists() && loggingProperties.canRead() && loggingProperties.isFile()) {
                System.setProperty("java.util.logging.config.file", loggingProperties.getAbsolutePath());
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (IOException | SecurityException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            this.gf.start();
            this.runtime = new PayaraMicroRuntime(this.instanceName, this.gf, gfruntime);
            this.deployAll();
            return this.runtime;
        }
        catch (GlassFishException ex) {
            throw new BootstrapException(ex.getMessage(), ex);
        }
    }

    public PayaraMicroRuntime getRuntime() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Payara Micro is not running");
        }
        return this.runtime;
    }

    public void shutdown() throws BootstrapException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Payara Micro is not running");
        }
        this.runtime.shutdown();
        this.runtime = null;
    }

    private void scanArgs(String[] args) {
        block54: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (null == arg) continue;
            switch (arg) {
                case "--port": {
                    String httpPortS = args[i + 1];
                    try {
                        this.httpPort = Integer.parseInt(httpPortS);
                        if (this.httpPort < 1 || this.httpPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid http port number", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--sslPort": {
                    String httpPortS = args[i + 1];
                    try {
                        this.sslPort = Integer.parseInt(httpPortS);
                        if (this.sslPort < 1 || this.sslPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid ssl port number and will be ignored", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--maxHttpThreads": {
                    String threads = args[i + 1];
                    try {
                        this.maxHttpThreads = Integer.parseInt(threads);
                        if (this.maxHttpThreads < 2) {
                            throw new NumberFormatException("Maximum Threads must be 2 or greater");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid maximum threads number and will be ignored", threads);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--minHttpThreads": {
                    String threads = args[i + 1];
                    try {
                        this.minHttpThreads = Integer.parseInt(threads);
                        if (this.minHttpThreads < 0) {
                            throw new NumberFormatException("Minimum Threads must be zero or greater");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid minimum threads number and will be ignored", threads);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--mcAddress": {
                    this.hzMulticastGroup = args[i + 1];
                    ++i;
                    continue block54;
                }
                case "--mcPort": {
                    String httpPortS = args[i + 1];
                    try {
                        this.hzPort = Integer.parseInt(httpPortS);
                        if (this.hzPort < 1 || this.hzPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid multicast port number and will be ignored", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--startPort": {
                    String startPort = args[i + 1];
                    try {
                        this.hzStartPort = Integer.parseInt(startPort);
                        if (this.hzStartPort < 1 || this.hzStartPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid port number and will be ignored", startPort);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--name": {
                    this.instanceName = args[i + 1];
                    ++i;
                    continue block54;
                }
                case "--deploymentDir": {
                    this.deploymentRoot = new File(args[i + 1]);
                    if (!this.deploymentRoot.exists() || !this.deploymentRoot.isDirectory()) {
                        logger.log(Level.SEVERE, "{0} is not a valid deployment directory and will be ignored", args[i + 1]);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--rootDir": {
                    this.rootDir = new File(args[i + 1]);
                    if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
                        logger.log(Level.SEVERE, "{0} is not a valid root directory and will be ignored", args[i + 1]);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--deploy": {
                    File deployment = new File(args[i + 1]);
                    if (!(deployment.exists() && deployment.isFile() && deployment.canRead() && (deployment.getName().endsWith(".war") || deployment.getName().endsWith(".ear") || deployment.getName().endsWith(".jar")))) {
                        logger.log(Level.SEVERE, "{0} is not a valid deployment path and will be ignored", deployment.getAbsolutePath());
                    } else {
                        if (this.deployments == null) {
                            this.deployments = new LinkedList<File>();
                        }
                        this.deployments.add(deployment);
                    }
                    ++i;
                    continue block54;
                }
                case "--domainConfig": {
                    this.alternateDomainXML = new File(args[i + 1]);
                    if (!(this.alternateDomainXML.exists() && this.alternateDomainXML.isFile() && this.alternateDomainXML.canRead() && this.alternateDomainXML.getAbsolutePath().endsWith(".xml"))) {
                        logger.log(Level.SEVERE, "{0} is not a valid path to an xml file and will be ignored", this.alternateDomainXML.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--noCluster": {
                    this.noCluster = true;
                    continue block54;
                }
                case "--hzConfigFile": {
                    this.alternateHZConfigFile = new File(args[i + 1]);
                    if (!(this.alternateHZConfigFile.exists() && this.alternateHZConfigFile.isFile() && this.alternateHZConfigFile.canRead() && this.alternateHZConfigFile.getAbsolutePath().endsWith(".xml"))) {
                        logger.log(Level.SEVERE, "{0} is not a valid path to an xml file and will be ignored", this.alternateHZConfigFile.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--autoBindHttp": {
                    this.autoBindHttp = true;
                    continue block54;
                }
                case "--autoBindSsl": {
                    this.autoBindSsl = true;
                    continue block54;
                }
                case "--autoBindRange": {
                    String autoBindRangeString = args[i + 1];
                    try {
                        this.autoBindRange = Integer.parseInt(autoBindRangeString);
                        if (this.autoBindRange < 1) {
                            throw new NumberFormatException("Not a valid auto bind range");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid auto bind range number", autoBindRangeString);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block54;
                }
                case "--help": {
                    System.err.println("Usage: --noCluster  Disables clustering\n--port sets the http port\n--sslPort sets the https port number\n--mcAddress sets the cluster multicast group\n--mcPort sets the cluster multicast port\n--startPort sets the cluster start port number\n--name sets the instance name\n--rootDir Sets the root configuration directory and saves the configuration across restarts\n--deploymentDir if set to a valid directory all war files in this directory will be deployed\n--deploy specifies a war file to deploy\n--domainConfig overrides the complete server configuration with an alternative domain.xml file\n--minHttpThreads the minimum number of threads in the HTTP thread pool\n--maxHttpThreads the maximum number of threads in the HTTP thread pool\n--hzConfigFile the hazelcast-configuration file to use to override the in-built hazelcast cluster configuration\n--autoBindHttp sets autobinding of the http port to a non-bound port\n--autoBindSsl sets autobinding of the https port to a non-bound port\n--autoBindRange sets the maximum number of ports to look at for port autobinding\n--help Shows this message and exits\n");
                    System.exit(1);
                }
            }
        }
    }

    private void deployAll() throws GlassFishException {
        int deploymentCount = 0;
        Deployer deployer = this.gf.getDeployer();
        if (this.deployments != null) {
            for (File war : this.deployments) {
                if (war.exists() && war.isFile() && war.canRead()) {
                    deployer.deploy(war, "--availabilityenabled=true");
                    ++deploymentCount;
                    continue;
                }
                logger.log(Level.WARNING, "{0} is not a valid deployment", war.getAbsolutePath());
            }
        }
        if (this.deploymentRoot != null) {
            for (File war : this.deploymentRoot.listFiles()) {
                String warPath = war.getAbsolutePath();
                if (!war.isFile() || !war.canRead() || !warPath.endsWith(".war") && !warPath.endsWith(".ear") && !warPath.endsWith(".jar") && !warPath.endsWith(".rar")) continue;
                deployer.deploy(war, "--availabilityenabled=true");
                ++deploymentCount;
            }
        }
        logger.log(Level.INFO, "Deployed {0} wars", deploymentCount);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

            @Override
            public void run() {
                try {
                    if (PayaraMicro.this.gf != null) {
                        PayaraMicro.this.gf.stop();
                        PayaraMicro.this.gf.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void installFiles(GlassFishProperties gfproperties) {
        File configDir = new File(this.rootDir.getAbsolutePath(), "config");
        new File(this.rootDir.getAbsolutePath(), "docroot").mkdirs();
        configDir.mkdirs();
        String[] configFiles = new String[]{"config/keyfile", "config/server.policy", "config/cacerts.jks", "config/keystore.jks", "config/login.conf", "config/logging.properties", "config/admin-keyfile", "config/default-web.xml", "org/glassfish/embed/domain.xml"};
        ClassLoader cl = this.getClass().getClassLoader();
        for (String configFile : configFiles) {
            URL url = cl.getResource(configFile);
            if (url == null) continue;
            StaticGlassFishRuntime.copy(url, new File(configDir.getAbsoluteFile(), configFile.substring(configFile.lastIndexOf(47) + 1)), false);
        }
        URL brandingUrl = cl.getResource("config/branding/glassfish-version.properties");
        if (brandingUrl != null) {
            StaticGlassFishRuntime.copy(brandingUrl, new File(configDir.getAbsolutePath(), "branding/glassfish-version.properties"), false);
        }
        String configFileURI = gfproperties.getConfigFileURI();
        try {
            StaticGlassFishRuntime.copy(URI.create(configFileURI).toURL(), new File(configDir.getAbsolutePath(), "domain.xml"), true);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setSystemProperties() {
        try {
            Properties embeddedBootProperties = new Properties();
            ClassLoader loader = this.getClass().getClassLoader();
            embeddedBootProperties.load(loader.getResourceAsStream("payara-boot.properties"));
            for (Object key : embeddedBootProperties.keySet()) {
                String keyStr = (String)key;
                if (System.getProperty(keyStr) != null) continue;
                System.setProperty(keyStr, embeddedBootProperties.getProperty(keyStr));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    boolean isRunning() {
        try {
            return this.gf != null && this.gf.getStatus() == GlassFish.Status.STARTED;
        }
        catch (GlassFishException ex) {
            return false;
        }
    }
}

