/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import fish.payara.micro.BootstrapException;
import fish.payara.micro.BootstrapListener;
import fish.payara.micro.services.CDIEventListener;
import fish.payara.micro.services.PayaraClusterListener;
import fish.payara.micro.services.PayaraClusteredCDIEvent;
import fish.payara.micro.services.PayaraMicroInstance;
import fish.payara.micro.services.command.ClusterCommandResult;
import fish.payara.micro.services.data.InstanceDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;

public class PayaraMicroRuntime {
    private static final Logger logger = Logger.getLogger(PayaraMicroRuntime.class.getCanonicalName());
    private final GlassFish runtime;
    private final PayaraMicroInstance instanceService;
    private final String instanceName;
    private final HashSet<PayaraClusterListener> listeners;
    private GlassFishRuntime gfRuntime;

    PayaraMicroRuntime(String instanceName, GlassFish runtime) {
        this.runtime = runtime;
        this.instanceName = instanceName;
        this.listeners = new HashSet(10);
        try {
            this.instanceService = runtime.getService(PayaraMicroInstance.class, "payara-micro-instance");
            this.instanceService.setInstanceName(instanceName);
            this.instanceService.addBootstrapListener(new BootstrapListener(this));
        }
        catch (GlassFishException ex) {
            throw new IllegalStateException("Unable to retrieve the embedded Payara Micro HK2 service. Something bad has happened", ex);
        }
    }

    PayaraMicroRuntime(String instanceName, GlassFish instance, GlassFishRuntime gfRuntime) {
        this(instanceName, instance);
        this.gfRuntime = gfRuntime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void shutdown() throws BootstrapException {
        this.checkState();
        try {
            this.gfRuntime.shutdown();
        }
        catch (GlassFishException ex) {
            throw new BootstrapException("Unable to stop Payara Micro", ex);
        }
    }

    public Collection<InstanceDescriptor> getClusteredPayaras() {
        return this.instanceService.getClusteredPayaras();
    }

    public Collection<String> getDeployedApplicationNames() {
        this.checkState();
        try {
            return this.runtime.getDeployer().getDeployedApplications();
        }
        catch (GlassFishException ex) {
            logger.log(Level.SEVERE, "There was a problem obtaining the names of the applications", ex);
            return null;
        }
    }

    public Map<InstanceDescriptor, Future<ClusterCommandResult>> run(String command, String ... args) {
        Map<String, Future<ClusterCommandResult>> commandResult = this.instanceService.executeClusteredASAdmin(command, args);
        HashMap<InstanceDescriptor, Future<ClusterCommandResult>> result = new HashMap<InstanceDescriptor, Future<ClusterCommandResult>>(commandResult.size());
        for (String uuid : commandResult.keySet()) {
            InstanceDescriptor id = this.instanceService.getDescriptor(uuid);
            if (id == null) continue;
            result.put(id, commandResult.get(uuid));
        }
        return result;
    }

    public Map<InstanceDescriptor, Future<ClusterCommandResult>> run(Collection<InstanceDescriptor> members, String command, String ... args) {
        HashSet<String> memberUUIDs = new HashSet<String>(members.size());
        for (InstanceDescriptor member : members) {
            memberUUIDs.add(member.getMemberUUID());
        }
        Map<String, Future<ClusterCommandResult>> commandResult = this.instanceService.executeClusteredASAdmin(memberUUIDs, command, args);
        HashMap<InstanceDescriptor, Future<ClusterCommandResult>> result = new HashMap<InstanceDescriptor, Future<ClusterCommandResult>>(commandResult.size());
        for (String uuid : commandResult.keySet()) {
            InstanceDescriptor id = this.instanceService.getDescriptor(uuid);
            if (id == null) continue;
            result.put(id, commandResult.get(uuid));
        }
        return result;
    }

    public <T extends Serializable> Map<InstanceDescriptor, Future<T>> run(Callable<T> callable) {
        Map<String, Future<T>> runCallable = this.instanceService.runCallable(callable);
        HashMap<InstanceDescriptor, Future<T>> result = new HashMap<InstanceDescriptor, Future<T>>(runCallable.size());
        for (String uuid : runCallable.keySet()) {
            InstanceDescriptor id = this.instanceService.getDescriptor(uuid);
            if (id == null) continue;
            result.put(id, runCallable.get(uuid));
        }
        return result;
    }

    public <T extends Serializable> Map<InstanceDescriptor, Future<T>> run(Collection<InstanceDescriptor> members, Callable<T> callable) {
        HashSet<String> memberUUIDs = new HashSet<String>(members.size());
        for (InstanceDescriptor member : members) {
            memberUUIDs.add(member.getMemberUUID());
        }
        Map<String, Future<T>> runCallable = this.instanceService.runCallable(memberUUIDs, callable);
        HashMap<InstanceDescriptor, Future<T>> result = new HashMap<InstanceDescriptor, Future<T>>(runCallable.size());
        for (String uuid : runCallable.keySet()) {
            InstanceDescriptor id = this.instanceService.getDescriptor(uuid);
            if (id == null) continue;
            result.put(id, runCallable.get(uuid));
        }
        return result;
    }

    public boolean deploy(String name, String contextRoot, InputStream is) {
        this.checkState();
        boolean result = false;
        try {
            this.runtime.getDeployer().deploy(is, "--availabilityenabled=true", "--name", name, "--contextroot", contextRoot);
            result = true;
        }
        catch (GlassFishException gfe) {
            logger.log(Level.WARNING, "Failed to deploy archive ", gfe);
        }
        return result;
    }

    public boolean deploy(String name, InputStream is) {
        this.checkState();
        boolean result = false;
        try {
            this.runtime.getDeployer().deploy(is, "--availabilityenabled=true", "--name", name, "--contextroot", name);
            result = true;
        }
        catch (GlassFishException gfe) {
            logger.log(Level.WARNING, "Failed to deploy archive ", gfe);
        }
        return result;
    }

    public boolean deploy(File war) {
        this.checkState();
        boolean result = false;
        if (war.exists() && war.isFile() && war.canRead()) {
            try {
                this.runtime.getDeployer().deploy(war, "--availabilityenabled=true");
                result = true;
            }
            catch (GlassFishException ex) {
                logger.log(Level.WARNING, "Failed to deploy archive ", ex);
            }
        } else {
            logger.log(Level.WARNING, "{0} is not a valid deployment", war.getAbsolutePath());
        }
        return result;
    }

    public void undeploy(String name) {
        try {
            this.runtime.getDeployer().undeploy(name, new String[0]);
        }
        catch (GlassFishException ex) {
            logger.log(Level.WARNING, "Failed to undeploy application {0}", name);
        }
    }

    public void removeClusterListener(PayaraClusterListener listener) {
        this.listeners.remove(listener);
    }

    public void addClusterListener(PayaraClusterListener listener) {
        this.listeners.add(listener);
    }

    public void publishCDIEvent(PayaraClusteredCDIEvent event) {
        this.instanceService.pubishCDIEvent(event);
    }

    public void addCDIEventListener(CDIEventListener listener) {
        this.instanceService.addCDIListener(listener);
    }

    public InstanceDescriptor getLocalDescriptor() {
        return this.instanceService.getLocalDescriptor();
    }

    public void removeCDIEventListener(CDIEventListener listener) {
        this.instanceService.removeCDIListenr(listener);
    }

    private void checkState() {
        try {
            if (!this.runtime.getStatus().equals((Object)GlassFish.Status.STARTED)) {
                throw new IllegalStateException("Payara Micro is not Running");
            }
        }
        catch (GlassFishException ex) {
            throw new IllegalStateException("Payara Micro is not Running");
        }
    }

    void memberAdded(InstanceDescriptor id) {
        for (PayaraClusterListener listener : this.listeners) {
            listener.memberAdded(id);
        }
    }

    void memberRemoved(InstanceDescriptor id) {
        for (PayaraClusterListener listener : this.listeners) {
            listener.memberRemoved(id);
        }
    }
}

