/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="clear-cache")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="clear-cache")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="lclear-cache", description="Clears a JCache or Hazalcast IMap")})
public class ClearCache
implements AdminCommand {
    @Inject
    HazelcastCore hazelcast;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="name", defaultValue="")
    protected String cacheName;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (this.hazelcast.isEnabled()) {
            HazelcastInstance instance = this.hazelcast.getInstance();
            if (instance != null) {
                for (DistributedObject dobject : instance.getDistributedObjects()) {
                    if (!this.cacheName.equals(dobject.getName()) || !(dobject instanceof IMap)) continue;
                    ((IMap)dobject).clear();
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    actionReport.setMessage("Cleared Cache " + this.cacheName);
                    return;
                }
                CacheManager cm = this.hazelcast.getCachingProvider().getCacheManager();
                Cache cache = cm.getCache(this.cacheName);
                if (cache != null) {
                    cache.clear();
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                }
            } else {
                actionReport.setMessage("Hazelcast is not enabled");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        } else {
            actionReport.setMessage("Hazelcast is not enabled");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

