/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-hazelcast-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.hazelcast.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-hazelcast-configuration", description="List Hazelcast Configuration")})
public class GetHazelcastConfiguration
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        HazelcastRuntimeConfiguration runtimeConfiguration = config.getExtensionByType(HazelcastRuntimeConfiguration.class);
        ActionReport actionReport = context.getActionReport();
        String[] headers = new String[]{"Configuration File", "Enabled", "Start Port", "MulticastGroup", "MulticastPort", "JNDIName"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Object[] values = new Object[]{runtimeConfiguration.getHazelcastConfigurationFile(), runtimeConfiguration.getEnabled(), runtimeConfiguration.getStartPort(), runtimeConfiguration.getMulticastGroup(), runtimeConfiguration.getMulticastPort(), runtimeConfiguration.getJNDIName()};
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        Properties extraProps = new Properties();
        map.put("hazelcastConfigurationFile", values[0]);
        map.put("enabled", values[1]);
        map.put("startPort", values[2]);
        map.put("multicastGroup", values[3]);
        map.put("multicastPort", values[4]);
        map.put("jndiName", values[5]);
        extraProps.put("getHazelcastConfiguration", map);
        actionReport.setExtraProperties(extraProps);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

