/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.store;

import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster-store")
@RunLevel(value=10)
public class ClusteredStore {
    private static final Logger logger = Logger.getLogger(ClusteredStore.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;

    @PostConstruct
    public void postConstruct() {
        if (this.hzCore.isEnabled()) {
            logger.info("Payara Clustered Store Service Enabled");
        }
    }

    public boolean isEnabled() {
        return this.hzCore.isEnabled();
    }

    public boolean set(String storeName, Serializable key, Serializable value) {
        boolean result = false;
        if (this.isEnabled()) {
            this.hzCore.getInstance().getMap(storeName).set(key, value);
            result = true;
        }
        return result;
    }

    public boolean remove(String storeName, Serializable key) {
        boolean result = false;
        if (this.isEnabled()) {
            Object value = this.hzCore.getInstance().getMap(storeName).remove(key);
            result = true;
        }
        return result;
    }

    public boolean containsKey(String storeName, Serializable key) {
        boolean result = false;
        if (this.isEnabled()) {
            result = this.hzCore.getInstance().getMap(storeName).containsKey(key);
        }
        return result;
    }

    public Serializable get(String storeName, Serializable key) {
        return (Serializable)this.hzCore.getInstance().getMap(storeName).get(key);
    }
}

