/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.LifecycleSupport;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener {
    @LogMessageInfo(message="Checking isLoaded for id, {0}, {1}", level="SEVERE", cause="Could not find session associated with given ID", action="Verify the session ID")
    public static final String CHECKING_IS_LOADED_EXCEPTION = "AS-WEB-CORE-00357";
    @LogMessageInfo(message="Exception clearing the Store", level="SEVERE", cause="Could not instantiate PrivilegedStoreClear()", action="Verify if specified action's run() could remove all sessions from store")
    public static final String CLEARING_STORE_EXCEPTION = "AS-WEB-CORE-00358";
    @LogMessageInfo(message="createSession: Too many active sessions", level="WARNING")
    public static final String CREATE_SESSION_EXCEPTION = "AS-WEB-CORE-00359";
    @LogMessageInfo(message="Exception in the Store during load", level="SEVERE", cause="Could not instantiate PrivilegedStoreKeys()", action="Verify if specified action's run() does not throw exception")
    public static final String STORE_LOADING_EXCEPTION = "AS-WEB-CORE-00360";
    @LogMessageInfo(message="Loading {0} persisted sessions", level="FINE")
    public static final String LOADING_PERSISTED_SESSIONS = "AS-WEB-CORE-00361";
    @LogMessageInfo(message="Failed load session from store", level="SEVERE", cause="Could not restore sessions from store to manager's list", action="Verify if the sessions are valid")
    public static final String FAILED_LOAD_SESSION_EXCEPTION = "AS-WEB-CORE-00362";
    @LogMessageInfo(message="Can't load sessions from store", level="SEVERE", cause="Could not load sessions from store", action="Verify if there is no exception to get the array containing the session identifiers of all Sessions currently saved in this Store")
    public static final String CANNOT_LOAD_SESSION_EXCEPTION = "AS-WEB-CORE-00363";
    @LogMessageInfo(message="Exception in the Store during removeSession", level="SEVERE", cause="Could not instantiate PrivilegedStoreRemove()", action="Verify if the specified action's run() could remove the session with the specified session identifier from this Store")
    public static final String STORE_REMOVE_SESSION_EXCEPTION = "AS-WEB-CORE-00364";
    @LogMessageInfo(message="Exception removing session", level="SEVERE", cause="Could not remove specified session identifier from store", action="Verify if there is no I/O error occur")
    public static final String REMOVING_SESSION_EXCEPTION = "AS-WEB-CORE-00365";
    @LogMessageInfo(message="Saving {0} persisted sessions", level="FINE")
    public static final String SAVING_PERSISTED_SESSION = "AS-WEB-CORE-00366";
    @LogMessageInfo(message="Exception in the Store during swapIn", level="SEVERE", cause="Could not instantiate PrivilegedStoreLoad", action="Verify if action's run() can load and return the Session associated with the specified session identifier from this Store, without removing it")
    public static final String STORE_SWAP_IN_EXCEPTION = "AS-WEB-CORE-00367";
    @LogMessageInfo(message="Error deserializing Session {0}: {1}", level="SEVERE", cause="Deserialization error occur, and could not load and return the session associated with the specified session identifier from this Store", action="Verify if ClassNotFoundException occur")
    public static final String DESERILIZING_SESSION_EXCEPTION = "AS-WEB-CORE-00368";
    @LogMessageInfo(message="Session swapped in is invalid or expired", level="SEVERE", cause="Session swapped in is invalid or expired", action="Verify if current session is valid")
    public static final String INVALID_EXPIRED_SESSION_EXCEPTION = "AS-WEB-CORE-00369";
    @LogMessageInfo(message="Swapping session {0} in from Store", level="FINE")
    public static final String SWAPPING_SESSION_FROM_STORE = "AS-WEB-CORE-00370";
    @LogMessageInfo(message="Exception in the Store during writeSession", level="SEVERE", cause="Could not write the provided session to the Store", action="Verify if there are any I/O errors occur")
    public static final String STORE_WRITE_SESSION_EXCEPTION = "AS-WEB-CORE-00371";
    @LogMessageInfo(message="Error serializing Session {0}: {1}", level="SEVERE", cause="Could not save the specified Session into this Store", action="Verify if there are any I/O errors occur")
    public static final String SERIALIZING_SESSION_EXCEPTION = "AS-WEB-CORE-00372";
    @LogMessageInfo(message="Manager has already been started", level="INFO")
    public static final String MANAGER_STARTED_INFO = "AS-WEB-CORE-00373";
    @LogMessageInfo(message="No Store configured, persistence disabled", level="SEVERE", cause="Could not prepare for the beginning of active use of the public methods of this component", action="Verify if Store has been configured")
    public static final String NO_STORE_CONFIG_EXCEPTION = "AS-WEB-CORE-00374";
    @LogMessageInfo(message="Manager has not yet been started", level="INFO")
    public static final String MANAGER_NOT_STARTED_INFO = "AS-WEB-CORE-00375";
    @LogMessageInfo(message="Invalid session timeout setting {0}", level="SEVERE", cause="Could not set session timeout from given parameter", action="Verify the number format for session timeout setting")
    public static final String INVALID_SESSION_TIMEOUT_SETTING_EXCEPTION = "AS-WEB-CORE-00376";
    @LogMessageInfo(message="Swapping session {0} to Store, idle for {1} seconds", level="FINE")
    public static final String SWAPPING_SESSION_TO_STORE = "AS-WEB-CORE-00377";
    @LogMessageInfo(message="Too many active sessions, {0}, looking for idle sessions to swap out", level="FINE")
    public static final String TOO_MANY_ACTIVE_SESSION = "AS-WEB-CORE-00378";
    @LogMessageInfo(message="Swapping out session {0}, idle for {1} seconds too many sessions active", level="FINE")
    public static final String SWAP_OUT_SESSION = "AS-WEB-CORE-00379";
    @LogMessageInfo(message=" Backing up session {0} to Store, idle for {1} seconds", level="FINE")
    public static final String BACKUP_SESSION_TO_STORE = "AS-WEB-CORE-00380";
    private static final String info = "PersistentManagerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static final String name = "PersistentManagerBase";
    private boolean started = false;
    private Store store = null;
    private boolean saveOnRestart = true;
    private int maxIdleBackup = -1;
    private int minIdleSwap = -1;
    private int maxIdleSwap = -1;
    protected ConcurrentHashMap<String, Long> invalidatedSessions = new ConcurrentHashMap();
    private long rememberInvalidatedSessionIdMilliSecs = 60000L;

    public void backgroundProcess() {
        this.processExpires();
        this.processPersistenceChecks();
        this.processInvalidatedSessions();
        if (this.getStore() != null && this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
    }

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", (Object)oldBackup, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", (Object)oldMaxIdleSwap, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", (Object)oldMinIdleSwap, (Object)this.minIdleSwap);
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveIntervalSeconds(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
        if (container instanceof StandardContext) {
            StandardContext ctx = (StandardContext)container;
            int frequency = ctx.getManagerChecksFrequency();
            int reapIntervalSeconds = ctx.getBackgroundProcessorDelay();
            this.rememberInvalidatedSessionIdMilliSecs = (long)(frequency * reapIntervalSeconds) * 1000L * 2L;
            if (this.rememberInvalidatedSessionIdMilliSecs <= 0L) {
                this.rememberInvalidatedSessionIdMilliSecs = 60000L;
            }
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e) {
            String msg = MessageFormat.format(rb.getString(CHECKING_IS_LOADED_EXCEPTION), id, e.getMessage());
            log.log(Level.SEVERE, msg, e);
        }
        return false;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    @Override
    public String getName() {
        return name;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", (Object)oldSaveOnRestart, (Object)this.saveOnRestart);
    }

    @Override
    public void release() {
        super.release();
        this.clearStore();
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.log(Level.SEVERE, CLEARING_STORE_EXCEPTION, exception);
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, CLEARING_STORE_EXCEPTION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExpires() {
        if (!this.started) {
            return;
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            StandardSession session = (StandardSession)sessions[i];
            if (session.getIsValid() && !session.hasExpired() || !session.lockBackground()) continue;
            try {
                session.expire();
                continue;
            }
            finally {
                session.unlockBackground();
            }
        }
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    protected void processInvalidatedSessions() {
        if (!this.started) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        for (Map.Entry<String, Long> e : this.invalidatedSessions.entrySet()) {
            String id = e.getKey();
            Long timeAdded = e.getValue();
            if (timeAdded != null && timeNow - timeAdded <= this.rememberInvalidatedSessionIdMilliSecs) continue;
            this.removeFromInvalidatedSessions(id);
        }
    }

    @Override
    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(rb.getString(CREATE_SESSION_EXCEPTION));
        }
        return super.createSession();
    }

    @Override
    public Session createSession(String sessionId) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(rb.getString(CREATE_SESSION_EXCEPTION));
        }
        return super.createSession(sessionId);
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (!this.isSessionIdValid(id)) {
            return null;
        }
        Session session = super.findSession(id);
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public Session findSession(String id, boolean removeCachedCopy) throws IOException {
        Session theSession = super.findSession(id);
        if (theSession != null) {
            if (removeCachedCopy) {
                this.removeSuper(theSession);
                if (this.getStore() != null && this.getStore() instanceof StoreBase) {
                    ((StoreBase)this.getStore()).removeFromStoreCache(id);
                }
                theSession = null;
            } else {
                return theSession;
            }
        }
        theSession = this.findSession(id);
        return theSession;
    }

    protected Session superFindSession(String id) throws IOException {
        return super.findSession(id);
    }

    public void removeSuper(Session session) {
        super.remove(session);
    }

    @Override
    public void load() {
        this.sessions.clear();
        if (this.store == null) {
            return;
        }
        String[] ids = null;
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    ids = AccessController.doPrivileged(new PrivilegedStoreKeys());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.log(Level.SEVERE, STORE_LOADING_EXCEPTION, exception);
                }
            } else {
                ids = this.store.keys();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, CANNOT_LOAD_SESSION_EXCEPTION, e);
            return;
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LOADING_PERSISTED_SESSIONS, String.valueOf(n));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapIn(ids[i]);
                continue;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, FAILED_LOAD_SESSION_EXCEPTION, e);
            }
        }
    }

    @Override
    public void remove(Session session) {
        this.remove(session, true);
    }

    public void remove(Session session, boolean persistentRemove) {
        super.remove(session);
        if (persistentRemove && this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    private void removeSession(String id) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.log(Level.SEVERE, STORE_REMOVE_SESSION_EXCEPTION, exception);
                }
            } else {
                this.store.remove(id);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, REMOVING_SESSION_EXCEPTION, e);
        }
    }

    public void addToInvalidatedSessions(String sessionId) {
        this.invalidatedSessions.put(sessionId, System.currentTimeMillis());
    }

    public void removeFromInvalidatedSessions(String sessionId) {
        this.invalidatedSessions.remove(sessionId);
    }

    public boolean isSessionIdValid(String sessionId) {
        return !this.invalidatedSessions.containsKey(sessionId);
    }

    @Override
    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, SAVING_PERSISTED_SESSION, String.valueOf(n));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapOut(sessions[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Session swapIn(String id) throws IOException {
        return this.swapIn(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String id, String version) throws IOException {
        ClassLoader webappCl = null;
        ClassLoader curCl = null;
        if (this.getContainer() != null && this.getContainer().getLoader() != null) {
            webappCl = this.getContainer().getLoader().getClassLoader();
            curCl = Thread.currentThread().getContextClassLoader();
        }
        Session sess = null;
        if (webappCl != null && curCl != webappCl) {
            try {
                Thread.currentThread().setContextClassLoader(webappCl);
                sess = this.doSwapIn(id, version);
            }
            finally {
                Thread.currentThread().setContextClassLoader(curCl);
            }
        } else {
            sess = this.doSwapIn(id, version);
        }
        return sess;
    }

    private Session doSwapIn(String id, String version) throws IOException {
        Session session;
        block11: {
            if (this.store == null) {
                return null;
            }
            session = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        session = AccessController.doPrivileged(new PrivilegedStoreLoad(id));
                        break block11;
                    }
                    catch (PrivilegedActionException ex) {
                        Exception exception = ex.getException();
                        log.log(Level.SEVERE, STORE_SWAP_IN_EXCEPTION, exception);
                        if (exception instanceof IOException) {
                            throw (IOException)exception;
                        }
                        if (exception instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)exception;
                        }
                        break block11;
                    }
                }
                session = version != null ? ((StoreBase)this.store).load(id, version) : this.store.load(id);
            }
            catch (ClassNotFoundException e) {
                String msg = MessageFormat.format(rb.getString(DESERILIZING_SESSION_EXCEPTION), id, e);
                log.log(Level.SEVERE, msg);
                throw new IllegalStateException(msg);
            }
        }
        if (session == null) {
            return null;
        }
        if (!session.isValid()) {
            log.log(Level.SEVERE, INVALID_EXPIRED_SESSION_EXCEPTION);
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, SWAPPING_SESSION_FROM_STORE, id);
        }
        session.setManager(this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardContext)this.getContainer()).sessionPersistedStartEvent((StandardSession)session);
        if (this.isSessionVersioningSupported() && ((StandardSession)session).hasNonHttpLockOccurred()) {
            ((StandardSession)session).incrementVersion();
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.log(Level.SEVERE, STORE_WRITE_SESSION_EXCEPTION, exception);
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, SERIALIZING_SESSION_EXCEPTION, new Object[]{session.getIdInternal(), e});
            throw e;
        }
        finally {
            ((StandardContext)this.getContainer()).sessionPersistedEndEvent((StandardSession)session);
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, MANAGER_STARTED_INFO);
            }
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Force random number initialization starting");
        }
        this.generateSessionId();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Force random number initialization completed");
        }
        if (this.store == null) {
            log.log(Level.SEVERE, NO_STORE_CONFIG_EXCEPTION);
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stopping");
        }
        if (!this.isStarted()) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, MANAGER_NOT_STARTED_INFO);
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        this.resetRandom();
        if (this.initialized) {
            this.destroy();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveIntervalSeconds((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, INVALID_SESSION_TIMEOUT_SETTING_EXCEPTION, event.getNewValue().toString());
            }
        }
    }

    protected void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleSwap || timeIdle <= this.minIdleSwap) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, SWAPPING_SESSION_TO_STORE, new Object[]{session.getIdInternal(), timeIdle});
                }
                try {
                    this.swapOut(session);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, TOO_MANY_ACTIVE_SESSION, sessions.length);
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < sessions.length && toswap > 0; ++i) {
            StandardSession session;
            int timeIdle = (int)((timeNow - sessions[i].getLastAccessedTime()) / 1000L);
            if (timeIdle <= this.minIdleSwap || !(session = (StandardSession)sessions[i]).lockBackground()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, SWAP_OUT_SESSION, new Object[]{session.getIdInternal(), timeIdle});
            }
            try {
                this.swapOut(session);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
            }
            finally {
                session.unlockBackground();
            }
            --toswap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleBackup || !session.lockBackground()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, BACKUP_SESSION_TO_STORE, new Object[]{session.getIdInternal(), timeIdle});
                }
                try {
                    this.writeSession(session);
                    continue;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    session.unlockBackground();
                }
            }
        }
    }

    public String getMonitorAttributeValues() {
        return "";
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction<String[]> {
        PrivilegedStoreKeys() {
        }

        @Override
        public String[] run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction<Void> {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction<Session> {
        private String id;

        PrivilegedStoreLoad(String id) {
            this.id = id;
        }

        @Override
        public Session run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction<Void> {
        private String id;

        PrivilegedStoreRemove(String id) {
            this.id = id;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction<Void> {
        PrivilegedStoreClear() {
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }
}

