/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.DescriptorNotFoundContentHandler;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class XMLRelationshipMappingNodeValue
extends MappingNodeValue {
    public void processChild(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, Descriptor xmlDescriptor, Mapping mapping) throws SAXException {
        Object item;
        if (xmlDescriptor == null) {
            DescriptorNotFoundContentHandler handler = new DescriptorNotFoundContentHandler(unmarshalRecord, mapping);
            String qnameString = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
            }
            handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setLexicalHandler(handler);
            return;
        }
        if (xmlDescriptor.hasInheritance()) {
            Object indicator;
            XPathQName leafElementType;
            unmarshalRecord.setAttributes(atts);
            Object session = unmarshalRecord.getSession();
            Class classValue = ((ObjectBuilder)xmlDescriptor.getObjectBuilder()).classFromRow(unmarshalRecord, session);
            if (classValue == null && (leafElementType = unmarshalRecord.getLeafElementType()) != null && (indicator = ((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getClassIndicatorMapping().get(leafElementType)) != null) {
                classValue = (Class)indicator;
            }
            if (classValue != null) {
                xmlDescriptor = (Descriptor)session.getDescriptor(classValue);
            } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, (ClassDescriptor)((XMLDescriptor)((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getDescriptor()));
            }
        }
        ObjectBuilder targetObjectBuilder = (ObjectBuilder)xmlDescriptor.getObjectBuilder();
        CoreAttributeGroup group2 = unmarshalRecord.getUnmarshalAttributeGroup();
        CoreAttributeGroup nestedGroup = null;
        if (group2 == XMLRecord.DEFAULT_ATTRIBUTE_GROUP) {
            nestedGroup = group2;
        }
        if (nestedGroup == null && (nestedGroup = ((CoreAttributeItem)(item = group2.getItem(this.getMapping().getAttributeName()))).getGroup(xmlDescriptor.getJavaClass())) == null) {
            nestedGroup = ((CoreAttributeItem)item).getGroup() == null ? XMLRecord.DEFAULT_ATTRIBUTE_GROUP : ((CoreAttributeItem)item).getGroup();
        }
        UnmarshalRecord childRecord = unmarshalRecord.getChildUnmarshalRecord(targetObjectBuilder);
        childRecord.setAttributes(atts);
        childRecord.startDocument();
        childRecord.initializeRecord(null);
        childRecord.setUnmarshalAttributeGroup(nestedGroup);
        childRecord.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), xPathFragment.getShortName(), atts);
        XMLReader xmlReader = unmarshalRecord.getXMLReader();
        xmlReader.setContentHandler(childRecord);
        xmlReader.setLexicalHandler(childRecord);
    }

    protected Descriptor findReferenceDescriptor(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, Mapping mapping, UnmarshalKeepAsElementPolicy policy) {
        Descriptor returnDescriptor = null;
        if (atts != null) {
            Object xmlContext = ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getContext();
            String schemaType = null;
            schemaType = unmarshalRecord.isNamespaceAware() ? atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type") : atts.getValue("", "type");
            if (schemaType != null && (schemaType = schemaType.trim()).length() > 0) {
                Class<?> theClass;
                XPathFragment frag = new XPathFragment(schemaType, unmarshalRecord.getNamespaceSeparator(), unmarshalRecord.isNamespaceAware());
                QName qname = null;
                if (frag.hasNamespace()) {
                    String prefix = frag.getPrefix();
                    String url = unmarshalRecord.resolveNamespacePrefix(prefix);
                    frag.setNamespaceURI(url);
                    qname = new QName(url, frag.getLocalName());
                    unmarshalRecord.setTypeQName(qname);
                } else {
                    String url = unmarshalRecord.resolveNamespacePrefix("");
                    if (url != null) {
                        frag.setNamespaceURI(url);
                        qname = new QName(url, frag.getLocalName());
                        unmarshalRecord.setTypeQName(qname);
                    }
                    if (!unmarshalRecord.isNamespaceAware() || !((Unmarshaller)unmarshalRecord.getUnmarshaller()).getJsonTypeConfiguration().useXsdTypesWithPrefix()) {
                        qname = new QName("http://www.w3.org/2001/XMLSchema", frag.getLocalName());
                        unmarshalRecord.setTypeQName(qname);
                    }
                }
                returnDescriptor = (Descriptor)((Context)xmlContext).getDescriptorByGlobalType(frag);
                if (returnDescriptor == null && (policy == null || !policy.isKeepUnknownAsElement() && !policy.isKeepAllAsElement()) && (theClass = unmarshalRecord.getConversionManager().javaType(qname)) == null) {
                    throw XMLMarshalException.unknownXsiTypeValue(schemaType, mapping);
                }
            }
        }
        return returnDescriptor;
    }

    protected void addTypeAttribute(Descriptor descriptor, MarshalRecord marshalRecord, String schemaContext) {
        String typeValue = schemaContext.substring(1);
        String xsiPrefix = null;
        if (descriptor.getNamespaceResolver() != null) {
            xsiPrefix = ((NamespaceResolver)descriptor.getNamespaceResolver()).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = ((NamespaceResolver)descriptor.getNamespaceResolver()).generatePrefix("xsi");
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(xsiPrefix) + ':' + "type", typeValue);
    }

    protected void writeExtraNamespaces(List extraNamespaces, XMLRecord xmlRecord, CoreAbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        int i = 0;
        int extraNamespacesSize = extraNamespaces.size();
        while (i < extraNamespacesSize) {
            Namespace next = (Namespace)extraNamespaces.get(i);
            String prefix = next.getPrefix();
            if (((MarshalRecord)xmlRecord).hasCustomNamespaceMapper()) {
                prefix = ((NamespaceResolver)((MarshalRecord)xmlRecord).getNamespaceResolver()).resolveNamespaceURI(next.getNamespaceURI());
            }
            ((MarshalRecord)xmlRecord).namespaceDeclaration(prefix, next.getNamespaceURI());
            ++i;
        }
    }

    protected void setupHandlerForKeepAsElementPolicy(UnmarshalRecord unmarshalRecord, XPathFragment xPathFragment, Attributes atts) {
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        builder.setOwningRecord(unmarshalRecord);
        builder.setMixedContent(this.xPathNode.getUnmarshalNodeValue().isMixedContentNodeValue());
        try {
            String namespaceURI = "";
            if (xPathFragment.getNamespaceURI() != null) {
                namespaceURI = xPathFragment.getNamespaceURI();
            }
            String qName = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qName = String.valueOf(xPathFragment.getPrefix()) + unmarshalRecord.getNamespaceSeparator() + qName;
            }
            if (!unmarshalRecord.getPrefixesForFragment().isEmpty()) {
                for (Map.Entry<String, String> next : unmarshalRecord.getPrefixesForFragment().entrySet()) {
                    builder.startPrefixMapping(next.getKey(), next.getValue());
                }
            }
            builder.startElement(namespaceURI, xPathFragment.getLocalName(), qName, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(builder);
            xmlReader.setLexicalHandler(null);
        }
        catch (SAXException sAXException) {}
    }

    protected void setOrAddAttributeValueForKeepAsElement(SAXFragmentBuilder builder, Mapping mapping, XMLConverterMapping converter, UnmarshalRecord unmarshalRecord, boolean isCollection, Object collection) {
        Object node = builder.getNodes().remove(builder.getNodes().size() - 1);
        if (converter != null) {
            node = converter.convertDataValueToObjectValue(node, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        }
        if (isCollection) {
            if (collection != null) {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), node, collection);
            } else {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), node);
            }
        } else {
            unmarshalRecord.setAttributeValue(node, mapping);
        }
    }

    protected void endElementProcessText(UnmarshalRecord unmarshalRecord, XMLConverterMapping converter, XPathFragment xPathFragment, Object collection) {
        Object value = unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        if (!unmarshalRecord.isNil()) {
            QName qname = unmarshalRecord.getTypeQName();
            if (qname == null) {
                if ("".equals(value)) {
                    value = null;
                }
            } else {
                ConversionManager conversionManager = unmarshalRecord.getConversionManager();
                if (qname.equals(Constants.QNAME_QNAME)) {
                    value = conversionManager.buildQNameFromString((String)value, unmarshalRecord);
                } else {
                    Class theClass = this.getClassForQName(qname, conversionManager);
                    if (theClass != null) {
                        value = conversionManager.convertObject(value, theClass, qname);
                    }
                }
            }
            value = converter.convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
            this.setOrAddAttributeValue(unmarshalRecord, value, xPathFragment, collection);
        }
    }

    protected Class getClassForQName(QName qname, ConversionManager conversionManager) {
        Object field = this.getMapping().getField();
        if (field != null) {
            return ((Field)field).getJavaClass(qname, conversionManager);
        }
        return conversionManager.javaType(qname);
    }

    protected abstract void setOrAddAttributeValue(UnmarshalRecord var1, Object var2, XPathFragment var3, Object var4);
}

