/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class FetchGroup
extends AttributeGroup {
    private boolean shouldLoad;
    protected EntityFetchGroup entityFetchGroup;
    protected FetchGroupTracker rootEntity;

    public FetchGroup() {
    }

    public FetchGroup(String name) {
        super(name);
    }

    @Deprecated
    public Set<String> getAttributes() {
        return this.getAttributeNames();
    }

    public String onUnfetchedAttribute(FetchGroupTracker entity, String attributeName) {
        Object result;
        if (this.rootEntity != null) {
            return this.rootEntity._persistence_getFetchGroup().onUnfetchedAttribute(this.rootEntity, attributeName);
        }
        ReadObjectQuery query = new ReadObjectQuery(entity);
        query.setShouldUseDefaultFetchGroup(false);
        Session session = entity._persistence_getSession();
        boolean shouldLoadResultIntoSelectionObject = false;
        if (session.isUnitOfWork()) {
            shouldLoadResultIntoSelectionObject = !((UnitOfWork)session).isObjectRegistered(entity);
        } else {
            boolean bl = shouldLoadResultIntoSelectionObject = !session.getIdentityMapAccessor().containsObjectInIdentityMap(entity);
        }
        if (shouldLoadResultIntoSelectionObject) {
            query.setShouldLoadResultIntoSelectionObject(true);
            query.dontCheckCache();
            query.setShouldMaintainCache(false);
            entity._persistence_setFetchGroup(null);
            entity._persistence_setSession(null);
        }
        if ((result = session.executeQuery(query)) == null) {
            if (shouldLoadResultIntoSelectionObject) {
                entity._persistence_setFetchGroup(this);
                entity._persistence_setSession(session);
            }
            Object[] args = new Object[]{query.getSelectionId()};
            return ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_reference", args);
        }
        return null;
    }

    public String onUnfetchedAttributeForSet(FetchGroupTracker entity, String attributeName) {
        return this.onUnfetchedAttribute(entity, attributeName);
    }

    public FetchGroupTracker getRootEntity() {
        return this.rootEntity;
    }

    public void setRootEntity(FetchGroupTracker rootEntity) {
        this.rootEntity = rootEntity;
    }

    public void setShouldLoad(boolean shouldLoad) {
        this.shouldLoad = shouldLoad;
        if (this.superClassGroup != null) {
            ((FetchGroup)this.superClassGroup).setShouldLoad(shouldLoad);
        } else {
            this.setSubclassShouldLoad(shouldLoad);
        }
    }

    protected void setSubclassShouldLoad(boolean shouldLoad) {
        if (this.subClasses != null) {
            for (CoreAttributeGroup group2 : this.subClasses) {
                ((FetchGroup)group2).shouldLoad = shouldLoad;
                ((FetchGroup)group2).setSubclassShouldLoad(shouldLoad);
            }
        }
    }

    public void setShouldLoadAll(boolean shouldLoad) {
        this.setShouldLoad(shouldLoad);
        if (this.hasItems()) {
            for (Map.Entry entry : this.getItems().entrySet()) {
                FetchGroup group2 = (FetchGroup)((AttributeItem)entry.getValue()).getGroup();
                if (group2 == null) continue;
                group2.setShouldLoadAll(shouldLoad);
            }
        }
    }

    public boolean shouldLoad() {
        return this.shouldLoad;
    }

    @Override
    protected FetchGroup newGroup(String name, CoreAttributeGroup parent) {
        FetchGroup fetchGroup = new FetchGroup(name);
        if (parent != null) {
            fetchGroup.setShouldLoad(((FetchGroup)parent).shouldLoad());
        }
        return fetchGroup;
    }

    @Override
    public boolean isFetchGroup() {
        return true;
    }

    public boolean isEntityFetchGroup() {
        return false;
    }

    public LoadGroup toLoadGroupLoadOnly() {
        return this.toLoadGroup(new HashMap<AttributeGroup, LoadGroup>(), true);
    }

    @Override
    public FetchGroup clone() {
        return (FetchGroup)super.clone();
    }

    @Override
    public LoadGroup toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, boolean loadOnly) {
        if (loadOnly && !this.shouldLoad) {
            return null;
        }
        return super.toLoadGroup(cloneMap, loadOnly);
    }

    public EntityFetchGroup getEntityFetchGroup(FetchGroupManager fetchGroupManager) {
        if (this.entityFetchGroup == null) {
            this.entityFetchGroup = fetchGroupManager.getEntityFetchGroup(this.getAttributeNames());
        }
        return this.entityFetchGroup;
    }

    @Override
    public FetchGroup getGroup(String attributeNameOrPath) {
        return (FetchGroup)super.getGroup(attributeNameOrPath);
    }

    @Override
    public void addAttribute(String attributeNameOrPath, CoreAttributeGroup group2) {
        this.entityFetchGroup = null;
        super.addAttribute(attributeNameOrPath, group2 != null ? ((AttributeGroup)group2).toFetchGroup() : null);
    }

    @Override
    public void addAttribute(String attributeNameOrPath, Collection<? extends CoreAttributeGroup> groups) {
        this.entityFetchGroup = null;
        super.addAttribute(attributeNameOrPath, groups);
    }

    @Override
    public void addAttributeKey(String attributeNameOrPath, CoreAttributeGroup group2) {
        this.entityFetchGroup = null;
        super.addAttributeKey(attributeNameOrPath, group2 != null ? ((AttributeGroup)group2).toFetchGroup() : null);
    }
}

