/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.core.AMXMBeanMetadata;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@AMXMBeanMetadata(singleton=true, globalSingleton=true, leaf=true)
public final class MBeanTracker
implements NotificationListener,
MBeanRegistration,
MBeanTrackerMBean {
    final ConcurrentMap<ObjectName, Set<ObjectName>> mParentChildren = new ConcurrentHashMap<ObjectName, Set<ObjectName>>();
    final ConcurrentMap<ObjectName, ObjectName> mChildParent = new ConcurrentHashMap<ObjectName, ObjectName>();
    private volatile MBeanServer mServer;
    private volatile ObjectName mObjectName;
    private final String mDomain;
    private volatile boolean mEmitMBeanStatus;

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    public MBeanTracker(String jmxDomain) {
        this.mDomain = jmxDomain;
        this.mEmitMBeanStatus = false;
    }

    @Override
    public boolean getEmitMBeanStatus() {
        return this.mEmitMBeanStatus;
    }

    @Override
    public void setEmitMBeanStatus(boolean emit) {
        this.mEmitMBeanStatus = emit;
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            String type2 = notif.getType();
            ObjectName objectName = notif.getMBeanName();
            if (this.isRelevantMBean(objectName)) {
                if (type2.equals("JMX.mbean.registered")) {
                    if (this.mEmitMBeanStatus) {
                        System.out.println("AMX MBean registered: " + objectName);
                    }
                    this.addChild(objectName);
                } else if (type2.equals("JMX.mbean.unregistered")) {
                    if (this.mEmitMBeanStatus) {
                        System.out.println("AMX MBean UNregistered: " + objectName);
                    }
                    this.removeChild(objectName);
                }
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        this.mServer = server;
        this.mObjectName = nameIn;
        return nameIn;
    }

    @Override
    public final void postRegister(Boolean registrationSucceeded) {
        if (this.mServer == null) {
            return;
        }
        if (registrationSucceeded.booleanValue()) {
            try {
                this.mServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not register with MBeanServerDelegate", e);
            }
        }
        ObjectName pattern = Util.newObjectNamePattern(this.mDomain, "");
        Set<ObjectName> names = JMXUtil.queryNames(this.mServer, pattern, null);
        for (ObjectName o : names) {
            this.addChild(o);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
        if (this.mServer != null) {
            this.mServer.removeNotificationListener(this.mObjectName, this);
        }
    }

    @Override
    public final void postDeregister() {
    }

    private boolean isRelevantMBean(ObjectName child) {
        return child != null && this.mDomain.equals(child.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(ObjectName child) {
        if (this.mServer == null) {
            return;
        }
        ObjectName parent = null;
        try {
            parent = (ObjectName)this.mServer.getAttribute(child, "Parent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parent != null) {
            MBeanTracker mBeanTracker = this;
            synchronized (mBeanTracker) {
                this.mChildParent.put(child, parent);
                HashSet<ObjectName> children = (HashSet<ObjectName>)this.mParentChildren.get(parent);
                if (children == null) {
                    children = new HashSet<ObjectName>();
                    this.mParentChildren.put(parent, children);
                }
                children.add(child);
            }
        }
    }

    private synchronized ObjectName removeChild(ObjectName child) {
        Set children;
        ObjectName parent = (ObjectName)this.mChildParent.remove(child);
        if (parent != null && (children = (Set)this.mParentChildren.get(parent)) != null) {
            children.remove(child);
            if (children.isEmpty()) {
                this.mParentChildren.remove(parent);
            }
        }
        return parent;
    }

    @Override
    public ObjectName getParentOf(ObjectName child) {
        return (ObjectName)this.mChildParent.get(child);
    }

    @Override
    public synchronized Set<ObjectName> getChildrenOf(ObjectName parent) {
        Set children = (Set)this.mParentChildren.get(parent);
        if (children == null) {
            return Collections.emptySet();
        }
        return new HashSet<ObjectName>(children);
    }
}

