/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.inject.Inject;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="monitor")
@PerLookup
@I18n(value="monitor.command")
public class Monitor
implements AdminCommand {
    @Param(optional=true)
    private String type;
    @Param(optional=true)
    private String filter;
    @Inject
    private ServiceLocator habitat;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Monitor.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        MonitorContract mContract = null;
        for (MonitorContract m : this.habitat.getAllServices(MonitorContract.class, new Annotation[0])) {
            if (!m.getName().equals(this.type)) continue;
            mContract = m;
            break;
        }
        if (mContract != null) {
            mContract.process(report, this.filter);
            return;
        }
        if (this.habitat.getAllServices(MonitorContract.class, new Annotation[0]).size() != 0) {
            StringBuffer buf = new StringBuffer();
            Iterator<MonitorContract> contractsIterator = this.habitat.getAllServices(MonitorContract.class, new Annotation[0]).iterator();
            while (contractsIterator.hasNext()) {
                buf.append(contractsIterator.next().getName());
                if (!contractsIterator.hasNext()) continue;
                buf.append(", ");
            }
            String validTypes = buf.toString();
            report.setMessage(this.localStrings.getLocalString("monitor.type.error", "No type exists in habitat for the given monitor type {0}. Valid types are: {1}", this.type, validTypes));
        } else {
            report.setMessage(this.localStrings.getLocalString("monitor.type.invalid", "No type exists in habitat for the given monitor type {0}", this.type));
        }
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }
}

