/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.ibm.jbatch.spi.TaggedJobExecution;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommand;
import org.glassfish.batch.AbstractLongListCommand;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_ListBatchJobSteps")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="_ListBatchJobSteps")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_ListBatchJobSteps", description="_List Batch Job Steps")})
public class ListBatchJobSteps
extends AbstractLongListCommand {
    private static final String NAME = "stepName";
    private static final String STEP_ID = "stepId";
    private static final String BATCH_STATUS = "batchStatus";
    private static final String EXIT_STATUS = "exitStatus";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String STEP_METRICS = "stepMetrics";
    @Param(primary=true)
    String executionId;

    @Override
    protected void executeCommand(AdminCommandContext context, Properties extraProps) throws Exception {
        ColumnFormatter columnFormatter = new ColumnFormatter(this.getDisplayHeaders());
        ArrayList<Map<String, Object>> jobExecutions = new ArrayList<Map<String, Object>>();
        extraProps.put("listBatchJobSteps", jobExecutions);
        for (StepExecution je : this.findStepExecutions()) {
            try {
                jobExecutions.add(this.handleJob(je, columnFormatter));
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + ex);
                this.logger.log(Level.FINE, "Exception while getting jobExecution details ", ex);
            }
        }
        context.getActionReport().setMessage(columnFormatter.toString());
    }

    @Override
    protected final String[] getAllHeaders() {
        return new String[]{NAME, STEP_ID, START_TIME, END_TIME, BATCH_STATUS, EXIT_STATUS, STEP_METRICS};
    }

    @Override
    protected final String[] getDefaultHeaders() {
        return new String[]{NAME, STEP_ID, START_TIME, END_TIME, BATCH_STATUS, EXIT_STATUS};
    }

    private List<StepExecution> findStepExecutions() throws JobSecurityException, NoSuchJobExecutionException {
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        JobExecution je = jobOperator.getJobExecution(Long.valueOf(this.executionId));
        if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)((Object)je)).getTagName())) {
            throw new NoSuchJobExecutionException("No job execution exists for job execution id: " + this.executionId);
        }
        List<StepExecution> stepExecutions = jobOperator.getStepExecutions(Long.valueOf(this.executionId));
        if (stepExecutions == null || stepExecutions.size() == 0) {
            throw new NoSuchJobExecutionException("No job execution exists for job execution id: " + this.executionId);
        }
        return stepExecutions;
    }

    private Map<String, Object> handleJob(StepExecution stepExecution, ColumnFormatter columnFormatter) {
        HashMap<String, Object> jobInfo = new HashMap<String, Object>();
        int stepMetricsIndex = -1;
        StringTokenizer st = new StringTokenizer("", "");
        Object[] cfData = new String[this.getOutputHeaders().length];
        for (int index = 0; index < this.getOutputHeaders().length; ++index) {
            HashMap<String, Long> data = null;
            switch (this.getOutputHeaders()[index]) {
                case "stepName": {
                    data = stepExecution.getStepName();
                    break;
                }
                case "stepId": {
                    data = stepExecution.getStepExecutionId();
                    break;
                }
                case "batchStatus": {
                    data = stepExecution.getBatchStatus() != null ? stepExecution.getBatchStatus() : "";
                    break;
                }
                case "exitStatus": {
                    data = stepExecution.getExitStatus() != null ? stepExecution.getExitStatus() : "";
                    break;
                }
                case "startTime": {
                    if (stepExecution.getStartTime() != null) {
                        data = stepExecution.getStartTime().getTime();
                        cfData[index] = stepExecution.getStartTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "endTime": {
                    if (stepExecution.getEndTime() != null) {
                        data = stepExecution.getEndTime().getTime();
                        cfData[index] = stepExecution.getEndTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "stepMetrics": {
                    stepMetricsIndex = index;
                    HashMap<String, Long> metricMap = new HashMap<String, Long>();
                    if (stepExecution.getMetrics() != null) {
                        ColumnFormatter cf = new ColumnFormatter(new String[]{"METRICNAME", "VALUE"});
                        for (Metric metric : stepExecution.getMetrics()) {
                            metricMap.put(metric.getType().name(), metric.getValue());
                            cf.addRow(new Object[]{metric.getType().name(), metric.getValue()});
                        }
                        st = new StringTokenizer(cf.toString(), "\n");
                    }
                    data = metricMap;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header: " + this.getOutputHeaders()[index]);
                }
            }
            jobInfo.put(this.getOutputHeaders()[index], data);
            cfData[index] = stepMetricsIndex != index ? (cfData[index] == null ? ((Object)data).toString() : cfData[index]) : (st.hasMoreTokens() ? st.nextToken() : "");
        }
        columnFormatter.addRow(cfData);
        cfData = new String[this.getOutputHeaders().length];
        for (int i = 0; i < this.getOutputHeaders().length; ++i) {
            cfData[i] = "";
        }
        while (st.hasMoreTokens()) {
            cfData[stepMetricsIndex] = st.nextToken();
            columnFormatter.addRow(cfData);
        }
        return jobInfo;
    }
}

