/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.ListAppRefsCommand;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="show-component-status")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="show-component-status", description="Show Component Status", params={@RestParam(name="id", value="$parent")})})
public class ShowComponentStatusCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    VersioningService versioningService;
    private ActionReport report;
    private Logger logger;
    private List<String> matchedVersions = null;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        try {
            this.matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            this.report.failure(this.logger, e.getMessage());
            return false;
        }
        if (this.matchedVersions.isEmpty()) {
            this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        for (String mv : this.matchedVersions) {
            ApplicationRef ref;
            if (DeploymentUtils.isDomainTarget(this.target) || (ref = this.domain.getApplicationRefInTarget(mv, this.target)) == null) continue;
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(ref), "read"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        if (this.report == null) {
            throw new IllegalStateException("Internal Error: The report should have been initializes by the preAuthorization method");
        }
        ActionReport.MessagePart part = this.report.getTopMessagePart();
        for (String appName : this.matchedVersions) {
            ApplicationRef ref;
            String status = "disabled";
            if (!DeploymentUtils.isDomainTarget(this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
                this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", appName, this.target));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.domain.isAppEnabledInTarget(appName, this.target)) {
                status = "enabled";
            }
            ActionReport.MessagePart childPart = part.addChild();
            String message = localStrings.getLocalString("component.status", "Status of {0} is {1}.", appName, status);
            childPart.setMessage(message);
            childPart.addProperty("state", status);
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

